package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.block.ISoulSensitive;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IHopperFilter;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.api.util.IProgressSource;
import betterwithmods.client.model.filters.ModelWithResource;
import betterwithmods.client.model.render.RenderUtils;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.mechanical.BlockMechMachines;
import betterwithmods.common.blocks.tile.SimpleStackHandler;
import betterwithmods.common.blocks.tile.TileEntityVisibleInventory;
import betterwithmods.common.registry.HopperFilter;
import betterwithmods.common.registry.HopperInteractions;
import betterwithmods.util.InvUtils;
import betterwithmods.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Optional;

public class TileEntityFilteredHopper extends TileEntityVisibleInventory implements IMechanicalPower, IProgressSource {

    private final int STACK_SIZE = 8;
    public SimpleStackHandler filter;
    public IHopperFilter hopperFilter = HopperFilter.NONE;

    public int soulsRetained;
    public byte power;
    private int ejectCounter, ejectXPCounter;
    private int experienceCount, maxExperienceCount = 1000;
    private ISoulSensitive prevContainer;

    public TileEntityFilteredHopper() {
        this.ejectCounter = 0;
        this.experienceCount = 0;
        this.ejectXPCounter = 10;
        this.soulsRetained = 0;
        this.occupiedSlots = 0;
        this.hasCapability = facing -> facing == EnumFacing.DOWN || facing == EnumFacing.UP;
        this.filter = new SimpleStackHandler(1, this);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);

        if (tag.func_74764_b("EjectCounter"))
            this.ejectCounter = tag.func_74762_e("EjectCounter");
        if (tag.func_74764_b("XPCount"))
            this.experienceCount = tag.func_74762_e("XPCount");
        if (tag.func_74764_b("Souls"))
            this.soulsRetained = tag.func_74762_e("Souls");
        this.power = tag.func_74771_c("power");
        if (tag.func_74764_b("Item"))
            this.filter.setStackInSlot(0, new ItemStack(tag.func_74775_l("Item")));
        validateInventory();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        t.func_74768_a("EjectCounter", this.ejectCounter);
        t.func_74768_a("XPCount", this.experienceCount);
        t.func_74768_a("Souls", this.soulsRetained);
        t.func_74774_a("power", power);
        if (!filter.getStackInSlot(0).func_190926_b()) {
            NBTTagCompound itemTag = new NBTTagCompound();
            filter.getStackInSlot(0).func_77955_b(itemTag);
            t.func_74782_a("Item", itemTag);
        }
        return t;
    }

    public boolean isPowered() {
        return power > 0;
    }

    public boolean isXPFull() {
        return experienceCount >= maxExperienceCount;
    }

    public void insert(Entity entity) {
        if (!InvUtils.isFull(inventory) && entity instanceof EntityItem) {
            EntityItem item = (EntityItem) entity;
            if (item.field_70128_L)
                return;
            if (HopperInteractions.attemptToCraft(hopperFilter.getName(), getBlockWorld(), getBlockPos(), item, this)) {
                this.getBlockWorld().func_184148_a(null, field_174879_c.func_177958_n(), field_174879_c.func_177956_o(), field_174879_c.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2F, ((getBlockWorld().field_73012_v.nextFloat() - getBlockWorld().field_73012_v.nextFloat()) * 0.7F + 1.0F) * 2.0F);
            } else if (canFilterProcessItem(item.func_92059_d())) {
                if (InvUtils.insertFromWorld(inventory, item, 0, 18, false))
                    this.getBlockWorld().func_184148_a(null, field_174879_c.func_177958_n(), field_174879_c.func_177956_o(), field_174879_c.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2F, ((getBlockWorld().field_73012_v.nextFloat() - getBlockWorld().field_73012_v.nextFloat()) * 0.7F + 1.0F) * 2.0F);
            }
        }
        hopperFilter.onInsert(field_145850_b, field_174879_c, this, entity);
    }

    private void extract() {
        Optional<IItemHandler> inv = InvUtils.getItemHandler(field_145850_b, field_174879_c.func_177977_b(), EnumFacing.UP);
        if (ejectCounter > 2) {
            int slot = InvUtils.getFirstOccupiedStackInRange(inventory, 0, 17);
            if (slot != -1) {
                ItemStack stack = inventory.getStackInSlot(slot);
                if (inv.isPresent()) {
                    if (InvUtils.canInsert(inv.get(), stack, STACK_SIZE)) {
                        ItemStack insert = InvUtils.insert(inv.get(), stack, STACK_SIZE, false);
                        InvUtils.consumeItemsInInventory(inventory, stack, STACK_SIZE - insert.func_190916_E(), false);
                    }
                } else if (canDropIntoBlock(field_174879_c.func_177977_b())) {
                    InvUtils.consumeItemsInInventory(inventory, stack, STACK_SIZE, false);
                    InvUtils.spawnStack(field_145850_b, field_174879_c.func_177958_n() + 0.5, field_174879_c.func_177956_o() - 0.5, field_174879_c.func_177952_p() + 0.5, STACK_SIZE, stack);
                }
            }
            ejectCounter = 0;
        } else {
            ejectCounter++;
        }
        if (ejectXPCounter > 2) {
            if (canDropIntoBlock(field_174879_c.func_177977_b())) {
                if (experienceCount > 19) {
                    experienceCount -= 20;
                    spawnEntityXPOrb(20);
                }
            }
            ejectXPCounter = 0;
        } else {
            ejectXPCounter++;
        }
    }

    private boolean canDropIntoBlock(BlockPos pos) {
        return field_145850_b.func_180495_p(pos).func_185904_a().func_76222_j();
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            byte power = (byte) calculateInput();
            if (this.power != power) {
                this.power = power;
            }
            if (getBlock() != null)
                getBlock().setActive(field_145850_b, field_174879_c, isActive());
            if (isPowered()) {
                extract();
            }
        }

    }

    public boolean isActive() {
        return power > 0;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        int x = field_174879_c.func_177958_n();
        int y = field_174879_c.func_177956_o();
        int z = field_174879_c.func_177952_p();
        return this.getBlockWorld().func_175625_s(this.field_174879_c) == this && player.func_70092_e(x + 0.5D, y + 0.5D, z + 0.5D) <= 64.0D;
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (this.getBlockWorld() != null) {
            validateInventory();
        }
    }

    private boolean validateInventory() {
        boolean stateChanged = false;
        ItemStack filter = getFilterStack();
        IHopperFilter newFilter = BWRegistry.HOPPER_FILTERS.getFilter(filter);
        if (this.hopperFilter != newFilter) {
            this.hopperFilter = newFilter;
            stateChanged = true;
        }
        byte slotsOccupied = (byte) InvUtils.getOccupiedStacks(inventory, 0, 17);
        if (slotsOccupied != this.occupiedSlots) {
            this.occupiedSlots = slotsOccupied;
            stateChanged = true;
        }
        if (getBlockWorld() != null && stateChanged) {
            IBlockState state = getBlockWorld().func_180495_p(field_174879_c);
            getBlockWorld().func_184138_a(field_174879_c, state, state, 3);
        }

        return stateChanged;
    }

    public IHopperFilter getHopperFilter() {
        return hopperFilter;
    }

    private boolean canFilterProcessItem(ItemStack stack) {
        validateInventory();
        return hopperFilter.allow(stack);
    }

    private void spawnEntityXPOrb(int value) {
        double xOff = this.getBlockWorld().field_73012_v.nextDouble() * 0.1D + 0.45D;
        double yOff = -0.5D;
        double zOff = this.getBlockWorld().field_73012_v.nextDouble() * 0.1D + 0.45D;
        EntityXPOrb orb = new EntityXPOrb(this.getBlockWorld(), this.field_174879_c.func_177958_n() + xOff, this.field_174879_c.func_177956_o() + yOff, this.field_174879_c.func_177952_p() + zOff, value);
        orb.field_70159_w = 0.0D;
        orb.field_70181_x = 0.0D;
        orb.field_70179_y = 0.0D;
        this.getBlockWorld().func_72838_d(orb);
    }

    @Nullable
    public ISoulSensitive getSoulContainer() {
        Block block = field_145850_b.func_180495_p(field_174879_c.func_177977_b()).func_177230_c();
        if (block instanceof ISoulSensitive && ((ISoulSensitive) block).isSoulSensitive(field_145850_b, field_174879_c.func_177977_b())) {
            return (ISoulSensitive) block;
        }
        return null;
    }

    public void decreaseSoulCount(int numSouls) {
        this.soulsRetained = Math.max(soulsRetained - numSouls, 0);
        func_70296_d();
    }

    public void increaseSoulCount(int numSouls) {
        this.soulsRetained += numSouls;
        ISoulSensitive container = getSoulContainer();
        if (container != null) {
            if (prevContainer != container)
                soulsRetained = numSouls;
            int soulsConsumed = container.processSouls(this.getBlockWorld(), field_174879_c.func_177977_b(), this.soulsRetained);
            if (container.consumeSouls(this.getBlockWorld(), field_174879_c.func_177977_b(), soulsConsumed))
                this.soulsRetained -= soulsConsumed;

        } else {
            if (this.soulsRetained > 7 && !isPowered()) {
                if (WorldUtils.spawnGhast(field_145850_b, field_174879_c))
                    this.getBlockWorld().func_184133_a(null, this.field_174879_c, SoundEvents.field_189105_bM, SoundCategory.BLOCKS, 1.0F, getBlockWorld().field_73012_v.nextFloat() * 0.1F + 0.8F);
                overpower();
            }
        }
        prevContainer = container;
        func_70296_d();
    }

    @Override
    public int getInventorySize() {
        return 18;
    }

    @Override
    public SimpleStackHandler createItemStackHandler() {
        return new HopperHandler(getInventorySize(), this);
    }

    @Override
    public String getName() {
        return "inv.filtered_hopper.name";
    }

    @Override
    public int getMaxVisibleSlots() {
        return 18;
    }

    public ModelWithResource getModel() {
        return RenderUtils.getModelFromStack(getFilterStack());
    }

    public ItemStack getFilterStack() {
        return filter.getStackInSlot(0);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        if (facing.func_176740_k().func_176722_c())
            return BWMAPI.IMPLEMENTATION.getPowerOutput(field_145850_b, field_174879_c.func_177972_a(facing), facing.func_176734_d());
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 1;
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER)
            return true;
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER)
            return CapabilityMechanicalPower.MECHANICAL_POWER.cast(this);
        return super.getCapability(capability, facing);
    }

    @Override
    public World getBlockWorld() {
        return super.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.func_174877_v();
    }

    @Override
    public BlockMechMachines getBlock() {
        if (func_145838_q() instanceof BlockMechMachines)
            return (BlockMechMachines) func_145838_q();
        return null;
    }

    @Override
    public void onBreak() {
        super.onBreak();
        InvUtils.ejectInventoryContents(field_145850_b, field_174879_c, filter);
    }

    public int getExperienceCount() {
        return experienceCount;
    }

    public void setExperienceCount(int experienceCount) {
        this.experienceCount = experienceCount;
    }

    public int getMaxExperienceCount() {
        return maxExperienceCount;
    }

    @Override
    public int getMax() {
        return 1;
    }

    @Override
    public int getProgress() {
        return Math.min(power, 1);
    }

    private class HopperHandler extends SimpleStackHandler {
        TileEntityFilteredHopper hopper;

        public HopperHandler(int size, TileEntityFilteredHopper hopper) {
            super(size, hopper);
            this.hopper = hopper;
        }

        @Override
        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            field_145850_b.func_175704_b(field_174879_c, field_174879_c);
            getBlockWorld().func_184138_a(field_174879_c, field_145850_b.func_180495_p(field_174879_c), field_145850_b.func_180495_p(field_174879_c), 2);
        }

        @Nonnull
        @Override
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!hopper.canFilterProcessItem(stack))
                return stack;
            return super.insertItem(slot, stack, simulate);
        }

        @Override
        public int getSlotLimit(int slot) {
            return slot == 18 ? 1 : super.getSlotLimit(slot);
        }
    }


}
