package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.IColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.DimensionType;

public abstract class TileEntityBaseWindmill extends TileAxleGenerator implements IColor {
    protected int[] bladeMeta;

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < bladeMeta.length; i++) {
            if (tag.func_74764_b("Color_" + i))
                bladeMeta[i] = tag.func_74762_e("Color_" + i);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        for (int i = 0; i < bladeMeta.length; i++) {
            t.func_74768_a("Color_" + i, bladeMeta[i]);
        }
        t.func_74774_a("DyeIndex", this.dyeIndex);
        return t;
    }

    @Override
    public boolean dye(EnumDyeColor color) {
        boolean dyed = false;
        if (bladeMeta[dyeIndex] != color.func_176765_a()) {
            bladeMeta[dyeIndex] = color.func_176765_a();
            dyed = true;
            IBlockState state = getBlockWorld().func_180495_p(this.field_174879_c);
            this.getBlockWorld().func_184138_a(this.field_174879_c, state, state, 2);
            this.func_70296_d();
        }
        dyeIndex++;
        if (dyeIndex > (bladeMeta.length - 1))
            dyeIndex = 0;
        return dyed;
    }


    public int getBladeColor(int blade) {
        return bladeMeta[blade];
    }

    @Override
    public int getColor(int index) {
        return bladeMeta[index];
    }

    @Override
    public void calculatePower() {
        byte power = 0;
        if (isValid()) {
            if (field_145850_b.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
                if (field_145850_b.func_72911_I())
                    power = 3;
                else if (field_145850_b.func_72896_J())
                    power = 2;
                else
                    power = 1;
            } else {
                power = 1;
            }
        }

        if (power != this.power) {
            setPower(power);
        }
    }


    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

}
