package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.blocks.EnumTier;
import betterwithmods.common.blocks.mechanical.BlockBellows;
import betterwithmods.common.blocks.tile.TileBasic;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

import javax.annotation.Nonnull;

/**
 * Purpose:
 *
 * @author primetoxinz
 * @version 3/16/17
 */
public class TileBellows extends TileBasic implements IMechanicalPower {

    private int tick;
    private boolean continuous = false;
    private int power;

    public void onChange() {

        if (getBlock().getTier(field_145850_b,field_174879_c) == EnumTier.STEEL)
            continuous = true;
        int power = calculateInput();
        if (continuous) {
            if (power != this.power)
                this.power = power;
            if (this.power > 0) {
                if (tick >= 37) {
                    getBlock().setActive(field_145850_b, field_174879_c, !getBlock().isActive(field_145850_b.func_180495_p(field_174879_c)));
                    tick = 0;
                }
                tick++;
            }
        } else {
            if (power != this.power) {
                this.power = power;
                getBlock().setActive(field_145850_b, field_174879_c, this.power > 0);
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("power", power);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        power = compound.func_74762_e("power");
        super.func_145839_a(compound);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        if (facing != EnumFacing.UP && facing != getBlock().getFacing(field_145850_b.func_180495_p(field_174879_c)))
            return BWMAPI.IMPLEMENTATION.getPowerOutput(field_145850_b, field_174879_c.func_177972_a(facing), facing.func_176734_d());
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        if (getBlock().getTier(field_145850_b,field_174879_c) == EnumTier.STEEL)
            return 3;
        return 1;
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER)
            return true;
        return super.hasCapability(capability, facing);
    }

    @Nonnull
    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER)
            return CapabilityMechanicalPower.MECHANICAL_POWER.cast(this);
        return super.getCapability(capability, facing);
    }

    public BlockBellows getBlock() {
        if(this.func_145838_q() instanceof BlockBellows)
            return (BlockBellows) func_145838_q();
        throw new IllegalStateException("This TileEntity does not have the correct block, something is severely wrong. Report to the mod author immediately");
    }

    @Override
    public World getBlockWorld() {
        return super.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.func_174877_v();
    }

}
