package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.mechanical.BlockAxleGenerator;
import betterwithmods.common.blocks.mechanical.IBlockActive;
import betterwithmods.common.blocks.tile.TileBasic;
import betterwithmods.module.gameplay.Gameplay;
import betterwithmods.util.DirUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileAxleGenerator extends TileBasic implements ITickable, IMechanicalPower {
    //Every generator will take up a single block with no extended bounding box
    protected byte power = 0;
    public byte dyeIndex = 0;
    protected float runningSpeed = 0.4F;
    public float currentRotation = 0.0F;
    public float previousRotation = 0.0F;
    public float waterMod = 1;
    protected boolean isValid;

    protected int tick;

    public abstract void calculatePower();

    public abstract void verifyIntegrity();

    public abstract int getRadius();

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("CurrentRotation"))
            currentRotation = tag.func_74760_g("CurrentRotation");
        if (tag.func_74764_b("RotationSpeed"))
            previousRotation = tag.func_74760_g("RotationSpeed");
        if (tag.func_74764_b("power"))
            power = tag.func_74771_c("power");
        if (tag.func_74764_b("DyeIndex"))
            dyeIndex = tag.func_74771_c("DyeIndex");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        t.func_74774_a("power", power);
        t.func_74776_a("CurrentRotation", currentRotation);
        t.func_74776_a("RotationSpeed", previousRotation);
        return t;
    }

    public float getCurrentRotation() {
        return this.currentRotation;
    }

    public float getPrevRotation() {
        return this.previousRotation;
    }

    @Override
    public void func_73660_a() {
        tick++;
        if (tick % 20 == 0 && getBlockWorld().func_180495_p(field_174879_c).func_177230_c() instanceof BlockAxleGenerator) {
            verifyIntegrity();
            calculatePower();
        }

        if (isValid()) {
            if (power != 0) {
                this.previousRotation = this.power * runningSpeed * waterMod;
                this.currentRotation += (this.power * this.power) * runningSpeed * waterMod;
                this.currentRotation %= 360;
                if (this.getBlockWorld().field_73012_v.nextInt(100) == 0)
                    this.getBlockWorld().func_184133_a(null, field_174879_c, BWSounds.WOODCREAK, SoundCategory.BLOCKS, 0.5F, getBlockWorld().field_73012_v.nextFloat() * 0.25F + 0.25F);
            } else {
                previousRotation = 0;
                currentRotation = 0;
            }
        }
    }

    public boolean isOverworld() {
        return field_145850_b.field_73011_w.func_76569_d();
    }

    public boolean isEnd() {
        return field_145850_b.field_73011_w.func_186058_p() == DimensionType.THE_END;
    }

    public boolean isNether() {
        return field_145850_b.field_73011_w.func_177495_o();
    }

    public void setPower(byte power) {
        this.power = power;
        field_145850_b.func_175656_a(field_174879_c, field_145850_b.func_180495_p(field_174879_c).func_177226_a(IBlockActive.ACTIVE, power > 0));
    }

    public boolean isValid() {
        return isValid;
    }


    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    //Unless you increase this, expect to see the TESR to pop in as you approach.
    @Override
    @SideOnly(Side.CLIENT)
    public double func_145833_n() {
       return Gameplay.generatorRenderDistance * Gameplay.generatorRenderDistance;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityMechanicalPower.MECHANICAL_POWER || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return CapabilityMechanicalPower.MECHANICAL_POWER.cast(this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return power;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 0;
    }

    public EnumFacing getOrientation() {
        if (field_145850_b.func_180495_p(field_174879_c).func_177230_c() instanceof BlockAxleGenerator) {
            EnumFacing.Axis axis = field_145850_b.func_180495_p(field_174879_c).func_177229_b(DirUtils.AXIS);
            switch (axis) {
                case X:
                    return EnumFacing.EAST;
                case Z:
                    return EnumFacing.SOUTH;
                default:
                    return EnumFacing.UP;
            }
        } else
            return EnumFacing.UP;
    }

    @Override
    public World getBlockWorld() {
        return super.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.func_174877_v();
    }

    @Override
    public Block getBlock() {
        return func_145838_q();
    }


}
