package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.block.IOverpower;
import betterwithmods.api.capabilities.CapabilityAxle;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IAxle;
import betterwithmods.api.tile.IAxleTick;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.BlockAxle;
import betterwithmods.common.blocks.tile.TileBasic;
import com.google.common.collect.Lists;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

import javax.annotation.Nullable;
import java.util.List;

/**
 * Created by primetoxinz on 7/18/17.
 */
public class TileAxle extends TileBasic implements IAxle, ITickable {
    private byte maxSignal;
    private int maxPower;
    private int minPower;

    private byte signal;
    private int power;

    public static List<IAxleTick> tickHandlers = Lists.newArrayList();

    public TileAxle() {

    }

    public TileAxle(int maxPower, int minPower, byte maxSignal) {
        this.maxPower = maxPower;
        this.minPower = minPower;
        this.maxSignal = maxSignal;
    }

    public void onChanged() {

        byte findSignal = 0;
        int findPower = 0;
        int sources = 0;

        for (EnumFacing facing : getDirections()) {
            BlockPos offset = field_174879_c.func_177972_a(facing);
            IMechanicalPower mech = BWMAPI.IMPLEMENTATION.getMechanicalPower(field_145850_b, offset, facing);
            if (mech != null) {

                IAxle axle = BWMAPI.IMPLEMENTATION.getAxle(field_145850_b, offset, facing);
                if (axle != null) {
                    if (isFacing(axle)) {
                        byte next = axle.getSignal();
                        if (next > findSignal) {
                            findSignal = next;
                        }
                    }
                }

                int power = mech.getMechanicalOutput(facing.func_176734_d());

                if (power > 0) {
                    if (power > findPower) {
                        sources++;
                        if (axle != null) {
                            if (axle.getSignal() >= findSignal)
                                findPower = power;
                        } else {
                            findPower = power;
                            if (getBlock() == BWMBlocks.STEEL_AXLE && mech.getClass() == TileGearbox.class) {
                                findPower = Math.max(1, findPower / 2);
                            }
                        }
                    }
                    if (axle == null) {
                        findSignal = getMaximumSignal();
                    }
                }

            }
        }

        setPower(findPower);

        if (sources >= 2) {
            ((IOverpower) func_145838_q()).overpower(field_145850_b, field_174879_c);
            return;
        }
        byte newSignal = 0;
        if (findSignal > signal) {
            if (findSignal == 1) {
                ((IOverpower) func_145838_q()).overpower(field_145850_b, field_174879_c);
            }
            if (power > 0)
                newSignal = (byte) (findSignal - 1);
        } else {
            newSignal = 0;
            setPower(0);
        }
        if (newSignal != this.signal)
            setSignal(newSignal);
        func_70296_d();
    }


    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74774_a("signal", signal);
        compound.func_74768_a("power", power);
        compound.func_74774_a("maxSignal", maxSignal);
        compound.func_74768_a("maxPower", maxPower);
        compound.func_74768_a("minPower", minPower);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.signal = compound.func_74771_c("signal");
        this.maxSignal = compound.func_74771_c("maxSignal");

        this.power = compound.func_74762_e("power");
        this.maxPower = compound.func_74762_e("maxPower");
        this.minPower = compound.func_74762_e("minPower");
        super.func_145839_a(compound);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || capability == CapabilityMechanicalPower.MECHANICAL_POWER || capability == CapabilityAxle.AXLE;
    }

    @Nullable
    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER)
            return CapabilityMechanicalPower.MECHANICAL_POWER.cast(this);
        if (capability == CapabilityAxle.AXLE)
            return CapabilityAxle.AXLE.cast(this);
        return super.getCapability(capability, facing);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        if (facing.func_176740_k() == getAxis()) {
            IAxle axle = BWMAPI.IMPLEMENTATION.getAxle(field_145850_b, field_174879_c.func_177972_a(facing), facing);
            if (axle != null && axle.getSignal() > this.getSignal())
                return 0;
            return power;
        }
        return 0;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        return maxPower;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return getMaximumInput();
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public byte getSignal() {
        return signal;
    }

    @Override
    public byte getMaximumSignal() {
        return maxSignal;
    }

    @Override
    public int getMaximumInput() {
        return maxPower;
    }

    @Override
    public int getMinimumInput() {
        return minPower;
    }

    public EnumFacing[] getDirections() {
        return ((BlockAxle) func_145838_q()).getAxisDirections(field_145850_b.func_180495_p(field_174879_c));
    }

    @Override
    public EnumFacing.Axis getAxis() {
        return ((BlockAxle) func_145838_q()).getAxis(field_145850_b.func_180495_p(field_174879_c));
    }

    public void setSignal(byte signal) {
        this.signal = signal;
    }

    public void setPower(int power) {
        this.power = Math.min(power, maxPower + 1);
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        ((BlockAxle) func_145838_q()).setActive(field_145850_b, field_174879_c, getPower() > 0);
        for (EnumFacing facing : getDirections()) {
            if (!BWMAPI.IMPLEMENTATION.isAxle(field_145850_b, field_174879_c.func_177972_a(facing), facing.func_176734_d())) {
                field_145850_b.func_190524_a(field_174879_c.func_177972_a(facing), func_145838_q(), field_174879_c);
            }
        }
    }

    public int getPower() {
        return power;
    }

    @Override
    public String toString() {
        return String.format("%s,%s,%s", signal, power, field_174879_c);
    }

    @Override
    public World getBlockWorld() {
        return super.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.func_174877_v();
    }

    @Override
    public Block getBlock() {
        return func_145838_q();
    }

    @Override
    public void func_73660_a() {
        if(!tickHandlers.isEmpty())
            tickHandlers.forEach(t -> t.tick(field_145850_b, field_174879_c, this));
    }
}

