package betterwithmods.common.blocks.mechanical;

import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

/**
 * Created by primetoxinz on 7/19/17.
 */
public interface IBlockActive {
    PropertyBool ACTIVE = PropertyBool.func_177716_a("active");

    default boolean isActive(IBlockState state) {
        if(state.func_177230_c() instanceof IBlockActive)
            return state.func_177229_b(ACTIVE);
        return false;
    }

    default void setActive(World world, BlockPos pos, boolean active) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IBlockActive) {
            if(state.func_177229_b(ACTIVE) != active)
                onChangeActive(world,pos,active);
            world.func_175656_a(pos, state.func_177226_a(ACTIVE, active));
            world.func_175684_a(pos, state.func_177230_c(),1);
        }
    }

    default void onChangeActive(World world, BlockPos pos, boolean newValue) {

    }
}
