package betterwithmods.common.blocks.mechanical;

import betterwithmods.BWMod;
import betterwithmods.api.block.IMultiVariants;
import betterwithmods.api.block.IOverpower;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.mechanical.tile.TileEntityFilteredHopper;
import betterwithmods.common.blocks.mechanical.tile.TileEntityMill;
import betterwithmods.common.blocks.mechanical.tile.TileEntityPulley;
import betterwithmods.common.blocks.mechanical.tile.TileEntityTurntable;
import betterwithmods.util.InvUtils;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.*;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

import javax.annotation.Nullable;
import java.util.Arrays;
import java.util.Random;

public class BlockMechMachines extends BWMBlock implements IBlockActive, IMultiVariants, IOverpower {

    public static final PropertyEnum<BlockMechMachines.EnumType> TYPE = PropertyEnum.func_177709_a("type", BlockMechMachines.EnumType.class);

    public BlockMechMachines() {
        super(Material.field_151576_e);
        this.func_149675_a(true);
        this.func_149711_c(3.5F);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, BlockMechMachines.EnumType.MILL).func_177226_a(ACTIVE, false));
        this.field_149783_u = true;
    }

    public static ItemStack getStack(EnumType type) {
        return new ItemStack(BWMBlocks.SINGLE_MACHINES, 1, type.getMeta());
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch (state.func_177229_b(TYPE)) {
            case HOPPER:
                return new AxisAlignedBB(0, 4 / 16d, 0, 1,  0.99d, 1);
            default:
                return super.func_185496_a(state, source, pos);
        }
    }

    @Override
    public String[] getVariants() {
        return new String[]{
                "active=false,type=mill",
                "active=false,type=pulley",
                "active=false,type=hopper",
                "active=false,type=turntable",
                "active=true,type=mill",
                "active=true,type=pulley",
                "active=true,type=hopper",
                "active=true,type=turntable",
        };
    }

    @SuppressWarnings("deprecation")
    @Override
    public Material func_149688_o(IBlockState state) {
        switch (state.func_177229_b(TYPE)) {
            case HOPPER:
            case PULLEY:
                setHarvestLevel("axe", 0, state);
                return Material.field_151575_d;
            default:
                setHarvestLevel("pickaxe", 0, state);
                return super.func_149688_o(state);
        }
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        switch (state.func_177229_b(TYPE)) {
            case HOPPER:
            case PULLEY:
                return SoundType.field_185848_a;
            default:
                return super.getSoundType(state, world, pos, entity);
        }
    }

    @Override
    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if(state.func_177230_c() == this) {
            BlockMechMachines.EnumType type = state.func_177229_b(TYPE);
            return type == EnumType.MILL || type == EnumType.PULLEY || type == EnumType.TURNTABLE;
        }
        return false;
    }

    public int tickRateForMeta(EnumType type) {
        if (type == EnumType.MILL)
            return 1;
        return 10;
    }

    @Override
    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return state.func_177229_b(TYPE) == EnumType.TURNTABLE &&  (side != null && side.func_176740_k().func_176722_c());
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        BlockMechMachines.EnumType type = world.func_180495_p(pos).func_177229_b(TYPE);
        world.func_180497_b(pos, this, tickRateForMeta(type), 5);
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        BlockMechMachines.EnumType type = state.func_177229_b(TYPE);
        return type.getMeta();
    }

    @Override
    @SideOnly(Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {

        return state.func_177229_b(TYPE).getSolidity();
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return state.func_177229_b(TYPE).getSolidity();
    }

    @Override
    public boolean func_149730_j(IBlockState state) {
        return state.func_177229_b(TYPE).getSolidity();
    }


    @Override
    public boolean func_176214_u(IBlockState state) {
        return state.func_177229_b(TYPE).getSolidity();
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        } else {

            boolean isInventory = Arrays.stream(EnumFacing.field_82609_l).anyMatch( f -> world.func_175625_s(pos).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f));

            if (!player.func_70093_af() && world.func_175625_s(pos) != null && isInventory) {
                player.openGui(BWMod.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityTurntable && hand == EnumHand.MAIN_HAND) {
                    return ((TileEntityTurntable) world.func_175625_s(pos)).processRightClick(player);
                }
            }
            return true;
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
            if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
                return InvUtils.calculateComparatorLevel(tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP));
            }
        }
        return 0;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_175625_s(pos) instanceof TileEntityTurntable) {
            if (!world.func_82736_K().func_82766_b("doDaylightCycle"))
                ((TileEntityTurntable) world.func_175625_s(pos)).toggleAsynchronous(null);
        }
    }

    @Override
    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        EnumType type = state.func_177229_b(TYPE);
        if(type == EnumType.HOPPER) {
            if(!worldIn.field_72995_K) {
                TileEntity tile = worldIn.func_175625_s(pos);
                if (tile instanceof TileEntityFilteredHopper) {
                    TileEntityFilteredHopper hopper = (TileEntityFilteredHopper) tile;
                    hopper.insert(entityIn);
                }
            }
            if(entityIn instanceof EntityItem) {
                entityIn.func_70107_b(entityIn.field_70165_t, entityIn.field_70163_u + 0.1, entityIn.field_70161_v); //Fix to stop items being caught on this
            }
        }
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        switch (state.func_177229_b(TYPE)) {
            case MILL:
                return new TileEntityMill();
            case PULLEY:
                return new TileEntityPulley();
            case HOPPER:
                return new TileEntityFilteredHopper();
            case TURNTABLE:
                return new TileEntityTurntable();
        }
        return null;
    }

    @Override
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType type : EnumType.META_LOOKUP)
            items.add(getStack(type));
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if(state.func_177229_b(TYPE) == EnumType.MILL && isActive(state)) {
            emitSmoke(world,pos,rand,5);
        }

    }

    private void emitSmoke(World world, BlockPos pos, Random rand, int heat) {
        for (int i = 0; i < heat; i++) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            float fX = x + rand.nextFloat();
            float fY = y + rand.nextFloat() * 0.5F + 1.0F;
            float fZ = z + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, fX, fY, fZ, 0.0D, 0.0D, 0.0D);
        }
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, ACTIVE, TYPE);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return func_176223_P().func_177226_a(TYPE, EnumType.byMeta(meta)).func_177226_a(ACTIVE, meta > 3);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(TYPE).getMeta() + (state.func_177229_b(ACTIVE) ? 4 : 0);
    }

    public static final ResourceLocation MILLSTONE = LootTableList.func_186375_a(new ResourceLocation(BWMod.MODID, "block/mill"));
    public static final ResourceLocation PULLEY = LootTableList.func_186375_a(new ResourceLocation(BWMod.MODID, "block/pulley"));
    public static final ResourceLocation HOPPER = LootTableList.func_186375_a(new ResourceLocation(BWMod.MODID, "block/hopper"));
    public static final ResourceLocation TURNTABLE = LootTableList.func_186375_a(new ResourceLocation(BWMod.MODID, "block/turntable"));

    @Override
    public void overpower(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        overpowerSound(world,pos);
        func_180663_b(world,pos, state);
        switch(state.func_177229_b(TYPE)) {
            case MILL:
                InvUtils.ejectBrokenItems(world,pos.func_177972_a(EnumFacing.func_176741_a(world.field_73012_v)),MILLSTONE);
                world.func_175698_g(pos);
                break;
            case PULLEY:
                InvUtils.ejectBrokenItems(world, pos.func_177972_a(EnumFacing.func_176741_a(world.field_73012_v)), PULLEY);
                world.func_175698_g(pos);
                break;
            case HOPPER:
                InvUtils.ejectBrokenItems(world, pos.func_177972_a(EnumFacing.func_176741_a(world.field_73012_v)), HOPPER);
                world.func_175698_g(pos);
                break;
            case TURNTABLE:
                InvUtils.ejectBrokenItems(world, pos.func_177972_a(EnumFacing.func_176741_a(world.field_73012_v)), TURNTABLE);
                world.func_175698_g(pos);
                break;
        }
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        switch(state.func_177229_b(TYPE)) {
            case HOPPER: return face == EnumFacing.UP ? BlockFaceShape.BOWL : BlockFaceShape.UNDEFINED;
            default: return BlockFaceShape.SOLID;
        }
    }

    public enum EnumType implements IStringSerializable {
        MILL(0, "mill", true),
        PULLEY(1, "pulley", true),
        HOPPER(2, "hopper"),
        TURNTABLE(3, "turntable", true);

        private static final BlockMechMachines.EnumType[] META_LOOKUP = values();

        private int meta;
        private String name;
        private boolean solidity;

        EnumType(int meta, String name) {
            this(meta, name, false);
        }

        EnumType(int meta, String name, boolean solid) {
            this.meta = meta;
            this.name = name;
            this.solidity = solid;
        }

        public static BlockMechMachines.EnumType byMeta(int meta) {
            return META_LOOKUP[meta % META_LOOKUP.length];
        }

        @Override
        public String func_176610_l() {
            return name;
        }

        public int getMeta() {
            return meta;
        }

        public boolean getSolidity() {
            return solidity;
        }
    }
}
