package betterwithmods.common.blocks.mechanical;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.block.IAdvancedRotationPlacement;
import betterwithmods.api.block.IOverpower;
import betterwithmods.api.block.IRenderRotationPlacement;
import betterwithmods.client.ClientEventHandler;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.common.blocks.EnumTier;
import betterwithmods.common.blocks.mechanical.tile.TileGearbox;
import betterwithmods.util.DirUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.*;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import java.util.Random;

import betterwithmods.api.block.IRenderRotationPlacement.RenderFunction;

public class BlockGearbox extends BlockRotate implements IBlockActive, IOverpower, IAdvancedRotationPlacement, IRenderRotationPlacement {
    private final int maxPower;
    private EnumTier type;

    public BlockGearbox(int maxPower, EnumTier type) {
        super(Material.field_151575_d);
        this.maxPower = maxPower;
        this.func_149711_c(2.0F);
        this.func_180632_j(func_176223_P().func_177226_a(DirUtils.FACING, EnumFacing.UP).func_177226_a(ACTIVE, false));
        this.type = type;
    }


    @Override
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a("tooltip.gearbox.name"));
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return getStateForAdvancedRotationPlacement(func_176223_P(), placer.func_70093_af() ? side : side.func_176734_d(), flX, flY, flZ);
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177231_a(DirUtils.FACING).func_177226_a(ACTIVE, false));
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_180497_b(pos, this, 5, 5);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        onChange(world, pos);
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        onChange(world, pos);
    }

    public void onChange(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            withTile(world, pos).ifPresent(TileGearbox::onChanged);
        }
    }


    public EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        return getFacingFromState(world.func_180495_p(pos));
    }

    public EnumFacing getFacingFromState(IBlockState state) {
        return state.func_177229_b(DirUtils.FACING);
    }


    private void emitGearboxParticles(World world, BlockPos pos, Random rand) {
        for (int i = 0; i < 5; i++) {
            float flX = pos.func_177958_n() + rand.nextFloat();
            float flY = pos.func_177956_o() + rand.nextFloat() * 0.5F + 1.0F;
            float flZ = pos.func_177952_p() + rand.nextFloat();

            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, flX, flY, flZ, 0.0D, 0.0D, 0.0D);
        }
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (state.func_177229_b(ACTIVE)) {
            emitGearboxParticles(world, pos, rand);

            if (rand.nextInt(10) == 0) {
                TileGearbox tile = getTile(world, pos);
                if (tile != null && tile.isOverpowered())
                    world.func_184134_a(pos.func_177958_n() + 0.5D, pos.func_177956_o() + 0.5D, pos.func_177952_p() + 0.5D, SoundEvents.field_187927_ha, SoundCategory.BLOCKS, 0.25F, world.field_73012_v.nextFloat() * 0.25F + 0.25F, true);
            }
            if (rand.nextInt(50) == 0) {
                world.func_184134_a(pos.func_177958_n() + 0.5D, pos.func_177956_o() + 0.5D, pos.func_177952_p() + 0.5D, BWSounds.WOODCREAK, SoundCategory.BLOCKS, 0.25F, world.field_73012_v.nextFloat() * 0.25F + 0.25F, false);
            }

        }
    }


    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean[] dirs = new boolean[6];
        for (int i = 0; i < 6; i++) {
            EnumFacing facing = EnumFacing.func_82600_a(i);
            dirs[i] = BWMAPI.IMPLEMENTATION.isAxle(world, pos.func_177972_a(facing), facing.func_176734_d()) && this.getFacing(world, pos) != facing;
        }
        return state.func_177226_a(DirUtils.DOWN, dirs[0]).func_177226_a(DirUtils.UP, dirs[1]).func_177226_a(DirUtils.NORTH, dirs[2]).func_177226_a(DirUtils.SOUTH, dirs[3]).func_177226_a(DirUtils.WEST, dirs[4]).func_177226_a(DirUtils.EAST, dirs[5]);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int facing = state.func_177229_b(DirUtils.FACING).func_176745_a();
        int active = isActive(state) ? 1 : 0;
        return active | facing << 1;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ACTIVE, (meta & 1) == 1).func_177226_a(DirUtils.FACING, EnumFacing.func_82600_a(meta >> 1));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, DirUtils.FACING, ACTIVE, DirUtils.UP, DirUtils.DOWN, DirUtils.NORTH, DirUtils.SOUTH, DirUtils.WEST, DirUtils.EAST);
    }

    @Override
    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    @Override
    public int func_180641_l(IBlockState state, World worldIn, BlockPos pos) {
        return isActive(state) ? 15 : 0;
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileGearbox(maxPower);
    }

    public Optional<TileGearbox> withTile(World world, BlockPos pos) {
        return Optional.of(getTile(world, pos));
    }

    public TileGearbox getTile(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileGearbox)
            return (TileGearbox) tile;
        return null;
    }

    @Override
    public void onChangeActive(World world, BlockPos pos, boolean newValue) {
        if (newValue) {
            world.func_184133_a(null, pos, BWSounds.WOODCREAK, SoundCategory.BLOCKS, 0.5F, world.field_73012_v.nextFloat() * 0.25F + 0.25F);
        }
    }

    @Override
    public void overpower(World world, BlockPos pos) {
        overpowerSound(world, pos);
        EnumFacing facing = world.func_180495_p(pos).func_177229_b(DirUtils.FACING);
        Block block = type == EnumTier.WOOD ? BWMBlocks.WOODEN_BROKEN_GEARBOX : BWMBlocks.STEEL_BROKEN_GEARBOX;
        world.func_175656_a(pos, block.func_176223_P().func_177226_a(DirUtils.FACING, facing));
    }


    @Override
    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (type == EnumTier.STEEL)
            return 4000f;
        return 0;
    }

    @Override
    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        if (type == EnumTier.STEEL)
            return 100f;
        return 3.5f;
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (type == EnumTier.STEEL)
            return SoundType.field_185852_e;
        return SoundType.field_185848_a;
    }

    @Override
    public Material func_149688_o(IBlockState state) {
        if (type == EnumTier.STEEL)
            return Material.field_151573_f;
        return Material.field_151575_d;
    }

    @Override
    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return type != EnumTier.STEEL || entity instanceof EntityPlayer;
    }

    @Override
    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (type != EnumTier.STEEL) {
            super.onBlockExploded(world, pos, explosion);
        }
    }

    @Override
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        EnumFacing facing = getFacingFromState(state);
        if (facing.func_176740_k().func_176722_c())
            return state.func_177226_a(DirUtils.FACING, rot.func_185831_a(facing));
        return state;
    }

    @Override
    public IBlockState getStateForAdvancedRotationPlacement(IBlockState defaultState, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = defaultState;
        float hitXFromCenter = hitX - 0.5F;
        float hitYFromCenter = hitY - 0.5F;
        float hitZFromCenter = hitZ - 0.5F;
        EnumFacing newFacing = facing;
        switch (facing.func_176740_k()) {
            case Y:
                if (inCenter(hitXFromCenter, hitZFromCenter, 1 / 16f)) {
                    newFacing = facing.func_176734_d();
                } else if (isMax(hitXFromCenter, hitZFromCenter)) {
                    newFacing = ((hitXFromCenter > 0) ? EnumFacing.EAST : EnumFacing.WEST);
                } else {
                    newFacing = ((hitZFromCenter > 0) ? EnumFacing.SOUTH : EnumFacing.NORTH);
                }
                break;
            case X:
                if (inCenter(hitYFromCenter, hitZFromCenter, 1 / 16f)) {
                    newFacing = facing;
                } else if (isMax(hitYFromCenter, hitZFromCenter)) {
                    newFacing = ((hitYFromCenter > 0) ? EnumFacing.UP : EnumFacing.DOWN);
                } else {
                    newFacing = ((hitZFromCenter > 0) ? EnumFacing.SOUTH : EnumFacing.NORTH);
                }
                break;
            case Z:
                if (inCenter(hitYFromCenter, hitXFromCenter, 1 / 16f)) {
                    newFacing = facing;
                } else if (isMax(hitYFromCenter, hitXFromCenter)) {
                    newFacing = ((hitYFromCenter > 0) ? EnumFacing.UP : EnumFacing.DOWN);
                } else {
                    newFacing = ((hitXFromCenter > 0) ? EnumFacing.EAST : EnumFacing.WEST);
                }
                break;
        }

        return state.func_177226_a(DirUtils.FACING, newFacing);

    }

    @Override
    public IBlockState getRenderState(World world, BlockPos pos, EnumFacing facing, float flX, float flY, float flZ, ItemStack stack, EntityLivingBase placer) {
        return getStateForAdvancedRotationPlacement(func_176223_P(), facing, flX, flY, flZ);
    }

    @Override
    public RenderFunction getRenderFunction() {
        return ClientEventHandler::renderBasicGrid;
    }
}
