package betterwithmods.common.blocks.mechanical;

import betterwithmods.util.DirUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraft.block.BlockRailBase.EnumRailDirection;

public class BlockGearBoostedRail extends BlockRailPowered {

    public static final double MOTION_CART = 0.05d;
    public static final double MOTION_SCALE = 0.06d;

    public BlockGearBoostedRail() {
        super();
        this.func_149711_c(0.7F);
        this.func_149672_a(SoundType.field_185852_e);
    }

    @Override
    protected void func_189541_b(IBlockState state, World world, BlockPos pos, Block block) {
        boolean poweredProperty = state.func_177229_b(field_176569_M);
        boolean isOnPoweredGearbox = isOnActiveGearbox(state, world, pos);
        if (poweredProperty != isOnPoweredGearbox) {
            world.func_180501_a(pos, state.func_177226_a(field_176569_M, isOnPoweredGearbox), 3);
            world.func_175685_c(pos.func_177977_b(), this, false);
            if (state.func_177229_b(field_176568_b).func_177018_c())
                world.func_175685_c(pos.func_177984_a(), this, false);
        }
    }

    private boolean isOnActiveGearbox(IBlockState state, World world, BlockPos pos) {
        if (!(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockGearbox)) return false;
        EnumRailDirection dir = state.func_177229_b(field_176568_b);
        IBlockState below = world.func_180495_p(pos.func_177977_b());
        EnumFacing face = below.func_177229_b(DirUtils.FACING);
        boolean correctFace = false;
        if (dir == EnumRailDirection.ASCENDING_EAST || dir == EnumRailDirection.ASCENDING_WEST || dir == EnumRailDirection.EAST_WEST) {
            correctFace = face == EnumFacing.DOWN || face == EnumFacing.NORTH || face == EnumFacing.SOUTH;
        } else if (dir == EnumRailDirection.ASCENDING_NORTH || dir == EnumRailDirection.ASCENDING_SOUTH || dir == EnumRailDirection.NORTH_SOUTH) {
            correctFace = face == EnumFacing.DOWN || face == EnumFacing.EAST || face == EnumFacing.WEST;
        }
        return correctFace && ((BlockGearbox) below.func_177230_c()).isActive(below);
    }

    @Override
    public boolean isFlexibleRail(IBlockAccess world, BlockPos pos) {
        return false;
    }

    private void accelerateMinecart(World world, EntityMinecart cart, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        double planarMotion = Math.sqrt(cart.field_70159_w * cart.field_70159_w + cart.field_70179_y * cart.field_70179_y);
        EnumFacing gearboxFace = world.func_180495_p(pos.func_177977_b()).func_177229_b(DirUtils.FACING);
        switch (state.func_177229_b(field_176568_b)) {
            case ASCENDING_NORTH:
            case ASCENDING_SOUTH:
            case NORTH_SOUTH:
                if (planarMotion > 0.01D) {
                    if ((gearboxFace == EnumFacing.EAST && cart.field_70179_y < 0.0D) ||
                            (gearboxFace == EnumFacing.WEST && cart.field_70179_y > 0.0D)) {
                        cart.field_70179_y -= cart.field_70179_y / planarMotion * MOTION_SCALE;
                        if (!world.field_72995_K && planarMotion > MOTION_CART && world.field_73012_v.nextDouble() < planarMotion)
                            world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 1.0F, 2.0F);
                    } else
                        cart.field_70179_y += cart.field_70179_y / planarMotion * MOTION_SCALE;
                } else {
                    if (gearboxFace == EnumFacing.EAST && !world.func_180495_p(pos.func_177976_e()).func_185914_p())
                        cart.field_70179_y = MOTION_CART;
                    else if (gearboxFace == EnumFacing.WEST && !world.func_180495_p(pos.func_177974_f()).func_185914_p())
                        cart.field_70179_y = -MOTION_CART;
                    else if (gearboxFace == EnumFacing.DOWN && world.func_180495_p(pos.func_177976_e()).func_185914_p())
                        cart.field_70179_y = MOTION_CART;
                    else if (gearboxFace == EnumFacing.DOWN && world.func_180495_p(pos.func_177974_f()).func_185914_p())
                        cart.field_70179_y = -MOTION_CART;
                }
                break;
            case ASCENDING_EAST:
            case ASCENDING_WEST:
            case EAST_WEST:
                if (planarMotion > 0.01D) {
                    if ((gearboxFace == EnumFacing.SOUTH && cart.field_70159_w > 0.0D) ||
                            (gearboxFace == EnumFacing.NORTH && cart.field_70159_w < 0.0D)) {
                        cart.field_70159_w -= cart.field_70159_w / planarMotion * MOTION_SCALE;
                        if (!world.field_72995_K && planarMotion > MOTION_CART && world.field_73012_v.nextDouble() < planarMotion)
                            world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 1.0F, 2.0F);
                    } else
                        cart.field_70159_w += cart.field_70159_w / planarMotion * MOTION_SCALE;
                } else {
                    if (gearboxFace == EnumFacing.SOUTH && !world.func_180495_p(pos.func_177976_e()).func_185914_p())
                        cart.field_70159_w = -MOTION_CART;
                    else if (gearboxFace == EnumFacing.NORTH && !world.func_180495_p(pos.func_177974_f()).func_185914_p())
                        cart.field_70159_w = MOTION_CART;
                    else if (gearboxFace == EnumFacing.DOWN && world.func_180495_p(pos.func_177976_e()).func_185914_p())
                        cart.field_70159_w = MOTION_CART;
                    else if (gearboxFace == EnumFacing.DOWN && world.func_180495_p(pos.func_177974_f()).func_185914_p())
                        cart.field_70159_w = -MOTION_CART;
                }
                break;
            default:
                break;
        }
    }

    private void decelerateMinecart(World world, EntityMinecart cart, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        double planarMotion = Math.sqrt(cart.field_70159_w * cart.field_70159_w + cart.field_70179_y * cart.field_70179_y);
        if (planarMotion > 0.01D) {
            double zMotion = Math.sqrt(cart.field_70179_y * cart.field_70179_y);
            double xMotion = Math.sqrt(cart.field_70159_w * cart.field_70159_w);
            if (xMotion > 0.0D) {
                cart.field_70159_w -= cart.field_70159_w / planarMotion * 0.06D;
            } else if (zMotion > 0.0D) {
                cart.field_70179_y -= cart.field_70179_y / planarMotion * 0.06D;
            }
            playBoosterSound(world, pos, planarMotion);
        } else if (state.func_177229_b(field_176568_b) == EnumRailDirection.EAST_WEST || state.func_177229_b(field_176568_b) == EnumRailDirection.NORTH_SOUTH) {
            cart.field_70159_w = 0.0D;
            cart.field_70179_y = 0.0D;
        }
    }

    /**
     * Plays a sound according to cart's motion.
     *
     * @param world        World.
     * @param pos          Position in the world.
     * @param planarMotion Motion of the cart.
     */
    private void playBoosterSound(World world, BlockPos pos, double planarMotion) {
        if (!world.field_72995_K && planarMotion > MOTION_CART && world.field_73012_v.nextDouble() < planarMotion)
            world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 1.0F, 2.0F);
    }

    @Override
    public void onMinecartPass(World world, EntityMinecart cart, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() == this)) return;
        IBlockState under = world.func_180495_p(pos.func_177977_b());
        Block blockUnder = under.func_177230_c();
        if (blockUnder instanceof BlockGearbox) {
            BlockGearbox gearbox = (BlockGearbox) blockUnder;
            EnumFacing face = world.func_180495_p(pos.func_177977_b()).func_177229_b(DirUtils.FACING);
            if (face == EnumFacing.UP) return;
            if (world.func_175640_z(pos.func_177977_b()))
                return;//=> No deceleration or acceleration if the block under the rail is powered.
            if (gearbox.isActive(under))
                accelerateMinecart(world, cart, pos);
            else
                decelerateMinecart(world, cart, pos);
        } else {
            double planarMotion = Math.sqrt(cart.field_70159_w * cart.field_70159_w + cart.field_70179_y * cart.field_70179_y);
            playBoosterSound(world, pos, planarMotion);
        }
    }
}
