package betterwithmods.common.blocks.mechanical;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.block.IMultiVariants;
import betterwithmods.api.block.IOverpower;
import betterwithmods.common.BWMItems;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.mechanical.tile.TileCrank;
import betterwithmods.module.ModuleLoader;
import betterwithmods.module.gameplay.Gameplay;
import betterwithmods.module.hardcore.needs.hunger.HCHunger;
import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.Random;

public class BlockCrank extends BWMBlock implements IMultiVariants, IOverpower {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a("stage", 0, 7);
    public static final float BASE_HEIGHT = 0.25F;
    private static final int TICK_RATE = 3;
    private static final AxisAlignedBB CRANK_AABB = new AxisAlignedBB(0.0F, 0.0F, 0.0F, 1.0F, BASE_HEIGHT, 1.0F);

    public BlockCrank() {
        super(Material.field_151576_e);
        this.func_149711_c(0.5F);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149675_a(true);
        this.func_180632_j(func_176223_P().func_177226_a(STAGE, 0));
        this.setHarvestLevel("pickaxe", 0);

    }

    @Override
    public int func_149738_a(World worldIn) {
        return TICK_RATE;
    }

    @Override
    public String[] getVariants() {
        return new String[]{"stage=0"};
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return CRANK_AABB;
    }

    @Override
    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_180497_b(pos, this, func_149738_a(worldIn), 5);
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        return world.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int meta = state.func_177229_b(STAGE);
        if (meta == 0) {
            if (Gameplay.crankExhaustion > 0.0) {
                int minHunger = ModuleLoader.isFeatureEnabled(HCHunger.class) ? 20 : 6;
                if (player.func_71024_bL().func_75116_a() > minHunger) {
                    player.func_71020_j((float) Gameplay.crankExhaustion);
                    if (!world.field_72995_K) {
                        toggleSwitch(world, pos, state);
                    }
                } else if (world.field_72995_K) {
                    if (hand == EnumHand.MAIN_HAND)
                        player.func_146105_b(new TextComponentTranslation("bwm.message.exhaustion"), true);
                    return false;
                }
            } else
                toggleSwitch(world, pos, state);
            return true;
        }
        return false;
    }

    private void toggleSwitch(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            if (!checkForOverpower(world, pos)) {
                world.func_175656_a(pos, state.func_177226_a(STAGE, 1));
                world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 1.0F, 2.0F);
                world.func_180497_b(pos, this, func_149738_a(world), 5);
            } else {
                overpower(world, pos);
            }
        }
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean checkForOverpower(World world, BlockPos pos) {
        int potentialDevices = 0;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos offset = pos.func_177972_a(facing);
            if (BWMAPI.IMPLEMENTATION.canInput(world, offset, facing)) {
                potentialDevices++;
            }
        }
        return potentialDevices > 1;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int stage = state.func_177229_b(STAGE);
        if (stage > 0) {
            if (stage < 7) {
                world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 1.0F, 2.0F);
                if (stage <= 5)
                    world.func_180497_b(pos, this, func_149738_a(world) + stage, 5);
                else
                    world.func_180497_b(pos, this, 18, 5);

                world.func_175656_a(pos, state.func_177226_a(STAGE, stage + 1));
            } else {
                world.func_175656_a(pos, state.func_177226_a(STAGE, 0));
                world.func_180497_b(pos, this, func_149738_a(world), 5);
                world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3F, 0.7F);
            }
        }
        world.func_175685_c(pos, this, false);
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        BlockPos down = pos.func_177977_b();
        if (!world.isSideSolid(down, EnumFacing.UP)) {
            func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(STAGE, meta);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(STAGE);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, STAGE);
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCrank();
    }

    @Override
    public void overpower(World world, BlockPos pos) {
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Items.field_151055_y));
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Blocks.field_150347_e, 2, 0));
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(BWMItems.MATERIAL, 1, 0));
        world.func_175698_g(pos);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.UNDEFINED : super.func_193383_a(worldIn, state, pos, face);
    }
}
