package betterwithmods.common.blocks.mechanical;

import betterwithmods.BWMod;
import betterwithmods.api.block.IMultiVariants;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.mechanical.tile.TileEntityCauldron;
import betterwithmods.common.blocks.mechanical.tile.TileEntityCrucible;
import betterwithmods.common.blocks.tile.TileEntityDragonVessel;
import betterwithmods.util.DirUtils;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.*;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

import javax.annotation.Nullable;

/**
 * Purpose:
 *
 * @author primetoxinz
 * @version 3/3/17
 */
public class BlockCookingPot extends BWMBlock implements IMultiVariants {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a("type", EnumType.class);
    public BlockCookingPot() {
        super(Material.field_151576_e);
        this.func_149711_c(3.5F);
    }

    public static ItemStack getStack(EnumType type) {
        return new ItemStack(BWMBlocks.COOKING_POTS, 1, type.getMeta());
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return state.func_177229_b(TYPE).getMeta();
    }

    @Override
    @SideOnly(Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType type : EnumType.VALUES)
            items.add(getStack(type));
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        switch (state.func_177229_b(TYPE)) {
            default:
                return SoundType.field_185851_d;
            case CRUCIBLE:
                return SoundType.field_185853_f;
        }
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, TYPE, DirUtils.TILTING);
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.func_176221_a(state, worldIn, pos);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(TYPE).getMeta();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return func_176223_P().func_177226_a(TYPE, EnumType.byMeta(meta));
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if(player.func_70093_af())
            return false;
        if (world.field_72995_K) {
            return true;
        } else {
            if (world.func_175625_s(pos) != null && world.func_175625_s(pos).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                player.openGui(BWMod.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
    }

    @Nullable
    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        switch (state.func_177229_b(TYPE)) {
            case CRUCIBLE:
                return new TileEntityCrucible();
            case CAULDRON:
                return new TileEntityCauldron();
            case DRAGONVESSEL:
                return new TileEntityDragonVessel();
            default:
                return super.createTileEntity(world, state);
        }
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return true;
    }

    @Override
    public String[] getVariants() {
        return new String[]{
                "facing=up,type=crucible",
                "facing=up,type=cauldron",
                "facing=up,type=dragonvessel",
        };
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == state.func_177229_b(DirUtils.TILTING) ? BlockFaceShape.BOWL : BlockFaceShape.CENTER_BIG;
    }

    public enum EnumType implements IStringSerializable {
        CRUCIBLE(0, "crucible"),
        CAULDRON(1, "cauldron"),
        DRAGONVESSEL(2, "dragonvessel");

        private static final EnumType[] VALUES = values();

        private int meta;
        private String name;

        EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static EnumType byMeta(int meta) {
            return VALUES[meta % VALUES.length];
        }

        @Override
        public String func_176610_l() {
            return name;
        }

        public int getMeta() {
            return meta;
        }

    }
}
