package betterwithmods.common.blocks.mechanical;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.EnumTier;
import betterwithmods.util.DirUtils;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

import static betterwithmods.util.DirUtils.AXIS;
import static net.minecraft.util.EnumFacing.Axis.Y;

public abstract class BlockAxleGenerator extends BWMBlock implements IBlockActive {

    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0F, 0.375F, 0.375F, 1.0F, 0.625F, 0.625F);
    private static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.375F, 0.0F, 0.375F, 0.625F, 1.0F, 0.625F);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375F, 0.375F, 0.0F, 0.625F, 0.625F, 1.0F);

    public BlockAxleGenerator(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(2.0F);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AXIS, EnumFacing.Axis.Z).func_177226_a(EnumTier.TIER, EnumTier.WOOD).func_177226_a(ACTIVE, false));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, AXIS, EnumTier.TIER, ACTIVE);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int axis = state.func_177229_b(AXIS).ordinal();
        int tier = state.func_177229_b(EnumTier.TIER).ordinal();
        int active = state.func_177229_b(ACTIVE) ? 1 : 0;
        return axis | tier << 2 | active << 3;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return func_176223_P().func_177226_a(AXIS, DirUtils.getAxis(meta & 3)).func_177226_a(EnumTier.TIER, EnumTier.VALUES[meta >> 2 & 1]).func_177226_a(ACTIVE,(meta >> 3)==1);
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch (state.func_177229_b(AXIS)) {
            case X:
                return X_AABB;
            case Y:
                return Y_AABB;
            case Z:
            default:
                return Z_AABB;
        }
    }

    @Override
    public int func_149738_a(World world) {
        return 20;
    }

    @Override
    public abstract ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state);

    @Override
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        if(state.func_177229_b(EnumTier.TIER) == EnumTier.WOOD) {
            drops.add(new ItemStack(BWMBlocks.WOODEN_AXLE));
        } else {
            drops.add(new ItemStack(BWMBlocks.STEEL_AXLE));
        }
        drops.add(func_185473_a((World) world, pos, state));

    }

    public IBlockState getAxisState(EnumFacing.Axis axis) {
        return this.func_176223_P().func_177226_a(AXIS, axis);
    }

    public EnumFacing.Axis getAxis(IBlockState state) {
        return state.func_177229_b(AXIS);
    }

    @Override
    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (world.func_180495_p(pos).func_177229_b(EnumTier.TIER) == EnumTier.STEEL)
            return 4000f;
        return 0;
    }

    @Override
    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177229_b(EnumTier.TIER)  == EnumTier.STEEL)
            return 100f;
        return 3.5f;
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (world.func_180495_p(pos).func_177229_b(EnumTier.TIER)  == EnumTier.STEEL)
            return SoundType.field_185852_e;
        return SoundType.field_185848_a;
    }

    @Override
    public Material func_149688_o(IBlockState state) {
        if (state.func_177229_b(EnumTier.TIER) == EnumTier.STEEL)
            return Material.field_151573_f;
        return Material.field_151575_d;
    }

    @Override
    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return getAxis(state) == Y;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face.func_176740_k() == getAxis(state) ? BlockFaceShape.CENTER : BlockFaceShape.UNDEFINED;
    }
}

