package betterwithmods.common.blocks.mechanical;

import betterwithmods.api.block.IOverpower;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.common.blocks.EnumTier;
import betterwithmods.common.blocks.mechanical.tile.TileAxle;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;
import java.util.Optional;
import java.util.Random;

import static betterwithmods.util.DirUtils.AXIS;
import static net.minecraft.util.EnumFacing.Axis.Y;

public class BlockAxle extends BlockRotate implements IOverpower, IBlockActive {

    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0F, 0.375F, 0.375F, 1.0F, 0.625F, 0.625F);
    private static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.375F, 0.0F, 0.375F, 0.625F, 1.0F, 0.625F);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375F, 0.375F, 0.0F, 0.625F, 0.625F, 1.0F);
    private EnumTier type;
    private final int minPower;
    private final int maxPower;
    private final int maxSignal;

    public BlockAxle(EnumTier type, int minPower, int maxPower, int maxSignal) {
        super(Material.field_151575_d);
        this.type = type;
        this.minPower = minPower;
        this.maxPower = maxPower;
        this.maxSignal = maxSignal;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AXIS, Y).func_177226_a(ACTIVE, false));
        func_149647_a(BWCreativeTabs.BWTAB);
    }

    public EnumTier getType() {
        return type;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, AXIS, ACTIVE);
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return func_176223_P().func_177226_a(AXIS, facing.func_176740_k());
    }


    @Override
    public IBlockState func_176203_a(int meta) {
        return func_176223_P().func_177226_a(AXIS, DirUtils.getAxis(meta >> 2)).func_177226_a(ACTIVE, (meta & 1) == 1);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int axis = state.func_177229_b(AXIS).ordinal() << 2;
        int active = state.func_177229_b(ACTIVE) ? 1 : 0;
        return active | axis;
    }


    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a(ACTIVE, false).func_177231_a(AXIS));
    }

    @Override
    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Override
    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return getAxis(state) == Y;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face.func_176740_k() == getAxis(state) ? BlockFaceShape.CENTER : BlockFaceShape.UNDEFINED;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch (state.func_177229_b(AXIS)) {
            case X:
                return X_AABB;
            case Y:
                return Y_AABB;
            case Z:
            default:
                return Z_AABB;
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) withTile(world, pos).ifPresent(System.out::println);
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_180497_b(pos, this, 1, 5);
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        onChange(world, pos);
    }


    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        onChange(worldIn, pos);
    }

    public void onChange(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            withTile(world, pos).ifPresent(TileAxle::onChanged);
        }
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileAxle(maxPower, minPower, (byte) (maxSignal + 1));
    }

    public Optional<TileAxle> withTile(World world, BlockPos pos) {
        return Optional.ofNullable(getTile(world, pos));
    }

    public TileAxle getTile(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAxle)
            return (TileAxle) tile;
        return null;
    }

    public EnumFacing[] getAxisDirections(IBlockState state) {
        if (state.func_177230_c() instanceof BlockAxle)
            return DirUtils.getAxisDirection(state.func_177229_b(AXIS));
        return new EnumFacing[0];
    }

    public EnumFacing.Axis getAxis(IBlockState state) {
        return state.func_177229_b(AXIS);
    }

    @Override
    public void overpower(World world, BlockPos pos) {
        world.func_175698_g(pos);
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(this, 1, func_180651_a(world.func_180495_p(pos))));
    }


    @Override
    @SideOnly(Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (isActive(state)) {
            emitAxleParticles(world, pos, rand);
            if (rand.nextInt(200) == 0)
                world.func_184134_a(pos.func_177958_n() + 0.5D, pos.func_177956_o() + 0.5D, pos.func_177952_p() + 0.5D, BWSounds.WOODCREAK, SoundCategory.BLOCKS, 0.15F, rand.nextFloat() * 0.1F + 0.5F, false);
        }
    }
    private void emitAxleParticles(World world, BlockPos pos, Random rand) {
        int pow;
        if (FMLClientHandler.instance().hasOptifine()) {
            IBlockState state = func_176221_a(world.func_180495_p(pos), world, pos);
            pow = state.func_177229_b(ACTIVE) ? 3 : 0;
        } else {
            pow = withTile(world, pos).map(TileAxle::getSignal).orElse((byte) 0);
        }
        for (int i = 0; i < pow; i++) {
            float flX = pos.func_177958_n() + rand.nextFloat();
            float flY = pos.func_177956_o() + rand.nextFloat() * 0.5F + 0.625F;
            float flZ = pos.func_177952_p() + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, flX, flY, flZ, 0.0D, 0.0D, 0.0D);
        }
    }


    @Override
    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (type == EnumTier.STEEL)
            return 4000f;
        return 0;
    }

    @Override
    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        if (type == EnumTier.STEEL)
            return 100f;
        return 3.5f;
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (type == EnumTier.STEEL)
            return SoundType.field_185852_e;
        return SoundType.field_185848_a;
    }

    @Override
    public Material func_149688_o(IBlockState state) {
        if (type == EnumTier.STEEL)
            return Material.field_151573_f;
        return Material.field_151575_d;
    }

    @Override
    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return type != EnumTier.STEEL || entity instanceof EntityPlayer;
    }

    @Override
    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (type != EnumTier.STEEL) {
            super.onBlockExploded(world, pos, explosion);
        }
    }
}
