package betterwithmods.common.blocks.behaviors;

import betterwithmods.api.tile.dispenser.IBehaviorCollect;
import betterwithmods.util.InvUtils;
import betterwithmods.util.ReflectionLib;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * Created by primetoxinz on 5/25/17.
 */
public class BehaviorSilkTouch implements IBehaviorCollect {

    private static final Method method = ReflectionHelper.findMethod(Block.class, ReflectionLib.SILK_TOUCH_DROP.getKey(), ReflectionLib.SILK_TOUCH_DROP.getValue(), IBlockState.class);

    public static ItemStack getBlockSilkTouchDrop(IBlockState state) {
        try {
            return (ItemStack) method.invoke(state.func_177230_c(), state);
        } catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public NonNullList<ItemStack> collect(IBlockSource source) {
        NonNullList<ItemStack> list = InvUtils.asNonnullList(getBlockSilkTouchDrop(source.func_189992_e()));
        breakBlock(source.func_82618_k(), source.func_189992_e(), source.func_180699_d());
        return list;
    }
}
