package betterwithmods.common.blocks.behaviors;

import betterwithmods.BWMod;
import betterwithmods.common.blocks.BlockBDispenser;
import betterwithmods.module.GlobalConfig;
import betterwithmods.util.DirUtils;
import betterwithmods.util.player.Profiles;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class BehaviorDefaultDispenseBlock extends BehaviorDefaultDispenseItem {
    @Override
    protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
        EnumFacing facing = source.func_189992_e().func_177229_b(BlockBDispenser.field_176441_a);

        IPosition pos = BlockBDispenser.func_149939_a(source);

        BlockPos check = new BlockPos(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());

        World world = source.func_82618_k();

        FakePlayer fake = FakePlayerFactory.get((WorldServer) world, Profiles.BWMDISP);
        fake.func_184611_a(EnumHand.MAIN_HAND, stack);
        DirUtils.setEntityOrientationFacing(fake, facing.func_176734_d());

        if (GlobalConfig.debug)
            BWMod.logger.debug("Better With Mods FakePlayer ID: " + fake.func_110124_au());

        if (!world.func_175623_d(check) && !world.func_180495_p(check).func_177230_c().func_176200_f(world, check))
            return ItemStack.field_190927_a;

        if (stack.func_77973_b() instanceof ItemBlock) {
            ItemBlock itemblock = (ItemBlock) stack.func_77973_b();
            if (itemblock.func_179222_a(world, check, facing, fake, stack)) {
                Block block = ((ItemBlock) stack.func_77973_b()).func_179223_d();
                boolean blockAcross = !world.func_175623_d(check.func_177972_a(facing));
                IBlockState state = block.getStateForPlacement(world, check, facing, getX(facing, blockAcross), getY(facing, blockAcross), getZ(facing, blockAcross), stack.func_77952_i(), fake, fake.func_184600_cs());
                if (block.func_176196_c(world, check)) {
                    if (itemblock.placeBlockAt(stack, fake, world, check, facing, getX(facing, blockAcross), getY(facing, blockAcross), getZ(facing, blockAcross), state)) {
                        world.func_184133_a(null, check, state.func_177230_c().getSoundType(state, world, check, fake).func_185841_e(), SoundCategory.BLOCKS, 0.7F, 1.0F);
                        stack.func_190918_g(1);
                        return stack.func_190926_b() ? ItemStack.field_190927_a : stack;
                    }
                }
            }
        } else if (stack.func_77973_b() instanceof ItemBlockSpecial) {
            if (stack.func_77973_b().func_180614_a(fake, world, check, EnumHand.MAIN_HAND, facing, 0.1F, 0.0F, 0.1F) == EnumActionResult.SUCCESS) {
                stack.func_190918_g(1);
                return stack.func_190926_b() ? ItemStack.field_190927_a : stack;
            }
        } else if (stack.func_77973_b() instanceof ItemSeeds) {
            if (stack.func_77973_b().func_180614_a(fake, world, check.func_177977_b(), EnumHand.MAIN_HAND, EnumFacing.UP, 0.1F, 0.0F, 0.1F) == EnumActionResult.SUCCESS) {
                stack.func_190918_g(1);
                return stack.func_190926_b() ? ItemStack.field_190927_a : stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    private float getX(EnumFacing facing, boolean blockAcross) {
        return facing == EnumFacing.NORTH && blockAcross ? 0.9F : 0.1F;
    }

    private float getY(EnumFacing facing, boolean blockAcross) {
        return facing == EnumFacing.UP && blockAcross ? 0.9F : 0.1F;
    }

    private float getZ(EnumFacing facing, boolean blockAcross) {
        return facing == EnumFacing.WEST && blockAcross ? 0.9F : 0.1F;
    }
}
