package betterwithmods.common.blocks.behaviors;

import betterwithmods.api.tile.dispenser.IBehaviorCollect;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import java.util.List;

/**
 * Created by primetoxinz on 5/25/17.
 */
public class BehaviorBreakBlock implements IBehaviorCollect {
    @Override
    public NonNullList<ItemStack> collect(IBlockSource source) {
        NonNullList<ItemStack> list = getDrops(source.func_82618_k(), source.func_180699_d(), source.func_189992_e(), 0);
        breakBlock(source.func_82618_k(), source.func_189992_e(), source.func_180699_d());
        return list;
    }


    public NonNullList<ItemStack> getDrops(World world, BlockPos pos, IBlockState state, int fortune) {
        NonNullList<ItemStack> finalDrops = NonNullList.func_191196_a();
        if (!world.field_72995_K && !world.restoringBlockSnapshots) // do not drop items while restoring blockstates, prevents item dupe
        {
            float chance = 1.0f;
            NonNullList<ItemStack> drops = NonNullList.func_191196_a();
            state.func_177230_c().getDrops(drops, world, pos, state, fortune);
            chance = net.minecraftforge.event.ForgeEventFactory.fireBlockHarvesting(drops, world, pos, state, fortune, chance, false, null);

            for (ItemStack drop : drops) {
                if (world.field_73012_v.nextFloat() <= chance) {
                    finalDrops.add(drop);
                }
            }
        }
        return finalDrops;
    }
}
