package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

public class BlockWoodTable extends BlockFurniture implements IMultiVariants {
    public BlockWoodTable() {
        super(Material.field_151575_d);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177230_c() instanceof BlockWoodTable) {
            BlockWoodTable block = (BlockWoodTable) state.func_177230_c();
            state = block.func_176221_a(state, source, pos);
            if (state.func_177229_b(SUPPORTED))
                return TABLE_AABB;
        }
        return field_185505_j;
    }

    @Override
    public String[] getVariants() {
        ArrayList<String> variants = new ArrayList<>();
        for (BlockPlanks.EnumType blockplanks$enumtype : BlockPlanks.EnumType.values()) {
            variants.add("supported=false,variant=" + blockplanks$enumtype.func_176610_l());
        }
        return variants.toArray(new String[variants.size()]);
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean pass) {
        func_185492_a(pos, entityBox, collidingBoxes, TABLE_AABB);
        if (state.func_177230_c() instanceof BlockWoodTable) {
            BlockWoodTable block = (BlockWoodTable) state.func_177230_c();
            state = block.func_176221_a(state, world, pos);
            if (!state.func_177229_b(SUPPORTED))
                func_185492_a(pos, entityBox, collidingBoxes, TABLE_STAND_AABB);
        }
    }

    @Override
    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return state.func_177229_b(BlockPlanks.field_176383_a).func_176839_a();
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(BlockPlanks.field_176383_a).func_176839_a();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.func_176837_a(meta));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, SUPPORTED, BlockPlanks.field_176383_a);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.CENTER : (face == EnumFacing.UP ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED);
    }

    @Override
    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() instanceof BlockWoodTable;
    }
}
