package betterwithmods.common.blocks;

import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.*;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.Random;

public class BlockWolf extends BWMBlock {

    private ResourceLocation entityName;

    public BlockWolf(ResourceLocation entityName) {
        super(Material.field_151580_n);
        this.entityName = entityName;
        this.func_149711_c(2.0F);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(DirUtils.FACING, EnumFacing.NORTH));
        registerBehavior();
    }

    private void registerBehavior() {
        BlockBDispenser.ENTITY_COLLECT_REGISTRY.func_82595_a(entityName, (world, pos, entity, stack) -> {
            if (((EntityAgeable) entity).func_70631_g_())
                return NonNullList.func_191196_a();
            InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Items.field_151007_F, 1 + world.field_73012_v.nextInt(3)));
            world.func_184133_a(null, pos, SoundEvents.field_187863_gH, SoundCategory.NEUTRAL, 0.75F, 1.0F);
            entity.func_70106_y();
            return InvUtils.asNonnullList(new ItemStack(this));
        });
    }

    @Override
    @SideOnly(Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.field_72995_K) {
            for (int i = 0; i < 15; i++)
                world.func_175688_a(EnumParticleTypes.HEART, pos.func_177958_n() + world.field_73012_v.nextFloat(), pos.func_177956_o() + 1.0F, pos.func_177952_p() + world.field_73012_v.nextFloat(), 0.0F, 0.1F, 0.0F);
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_184614_ca() .func_190926_b()  && player.func_184592_cb() .func_190926_b() ) {
            if (world.field_72995_K)
                world.func_175688_a(EnumParticleTypes.HEART, pos.func_177958_n() + world.field_73012_v.nextFloat(), pos.func_177956_o() + 1.0F, pos.func_177952_p() + world.field_73012_v.nextFloat(), 0.0F, 0.1F, 0.0F);
            return true;
        }
        return false;
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, placer, hand);
        return state.func_177226_a(DirUtils.FACING, DirUtils.convertEntityOrientationToFacing(placer, side));
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(200) == 0) {
            if (rand.nextBoolean())
                world.func_184134_a(pos.func_177958_n() + 0.5D, pos.func_177956_o() + 0.5D, pos.func_177952_p() + 0.5D, SoundEvents.field_187857_gE, SoundCategory.BLOCKS, 0.7F, 1.0F, false);
            else
                world.func_184134_a(pos.func_177958_n() + 0.5D, pos.func_177956_o() + 0.5D, pos.func_177952_p() + 0.5D, SoundEvents.field_187865_gI, SoundCategory.BLOCKS, 0.7F, 1.0F, false);
        }
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(DirUtils.FACING).ordinal();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(DirUtils.FACING, EnumFacing.func_82600_a(meta));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, DirUtils.FACING);
    }
}
