package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.tile.TileEntityVase;
import betterwithmods.util.ColorUtils;
import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

import java.util.Random;

/**
 * Created by Christian on 24.09.2016.
 */
public class BlockVase extends BWMBlock implements IMultiVariants {

    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.125D, 0, 0.125D, 0.875D, 1.0D, 0.875D);

    public BlockVase() {
        super(BWMBlocks.POTTERY);
        this.func_149711_c(2.0F);
        this.setHarvestLevel("pickaxe", -1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ColorUtils.COLOR, EnumDyeColor.WHITE));
        this.func_149672_a(SoundType.field_185853_f);
    }

    public static ItemStack getStack(EnumDyeColor type) {
        return new ItemStack(BWMBlocks.VASE, 1, type.func_176765_a());
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityVase();
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public String[] getVariants() {
        EnumDyeColor[] dyes = EnumDyeColor.values();
        String[] variants = new String[dyes.length];

        for (int i = 0; i < dyes.length; ++i) {
            EnumDyeColor dye = dyes[i];
            variants[i] = "color=" + dye.func_176610_l();
        }

        return variants;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            InvUtils.readFromStack(tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), stack);
        }
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (playerIn.func_70093_af())
            return false;
        InvUtils.getItemHandler(worldIn, pos, null).ifPresent(inv -> {
            if (InvUtils.insertSingle(inv, heldItem, false).func_190926_b()) {
                if (!playerIn.func_184812_l_())
                    heldItem.func_190918_g(1);
                worldIn.func_184148_a(null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(),
                        SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2F,
                        ((worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.7F + 1.0F) * 2.0F);
            }
        });
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && entity != null && entity instanceof EntityArrow) {
            world.func_175718_b(2001, pos, Block.func_176210_f(state));
            world.func_175666_e(pos, this);
            world.func_175698_g(pos);
        }
        super.func_180634_a(world, pos, state, entity);
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = new ItemStack(Item.func_150898_a(this), 1, state.func_177229_b(ColorUtils.COLOR).func_176765_a());
        TileEntity tile = world.func_175625_s(pos);
        if (!world.field_72995_K && tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            InvUtils.writeToStack(tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), stack);
        }
        return stack;
    }

    @Override
    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return (state.func_177229_b(ColorUtils.COLOR)).func_176765_a();
    }

    @Override
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumDyeColor color : EnumDyeColor.values())
            items.add(getStack(color));
        super.func_149666_a(itemIn, items);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ColorUtils.COLOR, EnumDyeColor.func_176764_b(meta));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(ColorUtils.COLOR).func_176765_a();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, ColorUtils.COLOR);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                return tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).getStackInSlot(0) != null ? 15 : 0;
            }
        }
        return 0;
    }

    @Override
    public int func_149745_a(Random random) {
        return 0;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.CENTER_BIG : (face == EnumFacing.UP ? BlockFaceShape.CENTER : BlockFaceShape.UNDEFINED); //Top is center instead of bowl to facilitate placing candles on these.
    }
}
