package betterwithmods.common.blocks;

import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import java.util.List;

public class BlockSteelPressurePlate extends BlockBasePressurePlate {

	public static final PropertyBool POWERED = PropertyBool.func_177716_a("powered");

	public BlockSteelPressurePlate() {
		super(Material.field_151573_f);
		this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(POWERED, false));
		func_149672_a(SoundType.field_185852_e);
	}

	protected int func_176576_e(IBlockState state) {
		return state.func_177229_b(POWERED) ? 15 : 0;
	}

	protected IBlockState func_176575_a(IBlockState state, int strength) {
		return state.func_177226_a(POWERED, strength > 0);
	}

	protected void func_185507_b(World worldIn, BlockPos color) {
		worldIn.func_184133_a(null, color, SoundEvents.field_187901_ga, SoundCategory.BLOCKS, 0.3F, 0.6F);
	}

	protected void func_185508_c(World worldIn, BlockPos pos) {
		worldIn.func_184133_a(null, pos, SoundEvents.field_187847_fZ, SoundCategory.BLOCKS, 0.3F, 0.5F);
	}

	protected int func_180669_e(World worldIn, BlockPos pos) {
		AxisAlignedBB axisalignedbb = field_185511_c.func_186670_a(pos);
		List<? extends Entity> list = worldIn.func_72872_a(EntityPlayer.class, axisalignedbb);
		if (!list.isEmpty()) {
			for (Entity entity : list) {
				if (!entity.func_145773_az()) {
					return 15;
				}
			}
		}

		return 0;
	}

	public IBlockState func_176203_a(int meta) {
		return this.func_176223_P().func_177226_a(POWERED, meta == 1);
	}

	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(POWERED) ? 1 : 0;
	}

	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, POWERED);
	}

}
