package betterwithmods.common.blocks;

import betterwithmods.BWMod;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.blocks.tile.TileEntitySteelAnvil;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

/**
 * Created by blueyu2 on 11/21/16.
 */
public class BlockSteelAnvil extends BlockContainer {

    public BlockSteelAnvil() {
        super(Material.field_151573_f);
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_149711_c(5.0F);
        this.func_149752_b(2000.0F);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149672_a(SoundType.field_185858_k);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(DirUtils.HORIZONTAL, EnumFacing.NORTH));
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        if (facing.ordinal() < 2)
            facing = DirUtils.convertEntityOrientationToFlatFacing(placer, facing);
        return state.func_177226_a(DirUtils.HORIZONTAL, facing.func_176746_e());
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch (state.func_177229_b(DirUtils.HORIZONTAL)) {
            case NORTH:
            case SOUTH:
                return new AxisAlignedBB(0.25F, 0.0F, 0.0F, 0.75F, 1.0F, 1.0F);
            case EAST:
            case WEST:
                return new AxisAlignedBB(0.0F, 0.0F, 0.25F, 1.0F, 1.0F, 0.75F);
            default:
                return new AxisAlignedBB(0.0F, 0.0F, 0.0F, 1.0F, 1.0F, 1.0F);
        }
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(DirUtils.HORIZONTAL).func_176736_b();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(DirUtils.HORIZONTAL, EnumFacing.func_176731_b(meta));
    }

    @Override
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, DirUtils.HORIZONTAL);
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K)
            return true;
        else
            playerIn.openGui(BWMod.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntitySteelAnvil();
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySteelAnvil();
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntitySteelAnvil anvil = (TileEntitySteelAnvil) worldIn.func_175625_s(pos);
        InvUtils.ejectInventoryContents(worldIn,pos,anvil.inventory);
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face.func_176740_k() == EnumFacing.Axis.Y ? BlockFaceShape.CENTER_BIG : BlockFaceShape.UNDEFINED;
    }
}
