package betterwithmods.common.blocks;

import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.List;

public class BlockStakeString extends BWMBlock {
    public BlockStakeString() {
        super(Material.field_151580_n);
        func_180632_j(func_176223_P().func_177226_a(DirUtils.NORTH, false).func_177226_a(DirUtils.SOUTH, false).func_177226_a(DirUtils.WEST, false).func_177226_a(DirUtils.EAST, false).func_177226_a(DirUtils.UP, false).func_177226_a(DirUtils.DOWN, false));
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, p_185477_7_);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = func_176221_a(state, source, pos);
        AxisAlignedBB box = new AxisAlignedBB(7 / 16d, 7 / 16d, 7 / 16d, 9 / 16d, 9 / 16d, 9 / 16d);
        if (state.func_177229_b(DirUtils.EAST))
            box = box.func_111270_a(new AxisAlignedBB(0, 7 / 16d, 7 / 16d, 0.5, 9 / 16d, 9 / 16d));
        if (state.func_177229_b(DirUtils.WEST))
            box = box.func_111270_a(new AxisAlignedBB(0.5, 7 / 16d, 7 / 16d, 1, 9 / 16d, 9 / 16d));
        if (state.func_177229_b(DirUtils.NORTH))
            box = box.func_111270_a(new AxisAlignedBB(7 / 16d, 7 / 16d, 0, 9 / 16d, 9 / 16d, 0.5));
        if (state.func_177229_b(DirUtils.SOUTH))
            box = box.func_111270_a(new AxisAlignedBB(7 / 16d, 7 / 16d, 0.5, 9 / 16d, 9 / 16d, 1));
        return box;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }


    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, DirUtils.UP, DirUtils.DOWN, DirUtils.NORTH, DirUtils.SOUTH, DirUtils.WEST, DirUtils.EAST);
    }

    @Override
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Items.field_151007_F);
    }

    @Override
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add(func_185473_a((World) world, pos, state));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return func_176223_P();
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState newState = state;

        for (int i = 0; i < EnumFacing.field_82609_l.length; i++) {
            newState = newState.func_177226_a(DirUtils.DIR_PROP[i], getDirection(worldIn, pos, EnumFacing.func_82600_a(i)));
        }
        return newState;
    }

    public static boolean getDirection(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return block instanceof BlockStakeString || block instanceof BlockStake;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void drop(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockStakeString) {
            InvUtils.ejectStackWithOffset(world, pos, func_185473_a(world, pos, world.func_180495_p(pos)));
            world.func_175698_g(pos);
        }
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        state = state.func_185899_b(worldIn,pos);
        for (int i = 0; i < DirUtils.DIR_PROP.length; i++) {
            if (state.func_177229_b(DirUtils.DIR_PROP[i])) {
                drop(worldIn, pos.func_177972_a(EnumFacing.func_82600_a(i)));
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }


    @Override
    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

}
