package betterwithmods.common.blocks;

import com.google.common.collect.Sets;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.Set;

import betterwithmods.common.blocks.BlockStickBase.Connection;

public class BlockShaft extends BlockStickBase {
    public BlockShaft() {
        super(Material.field_151575_d);
    }

    @Override
    public IBlockState getConnections(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState above = world.func_180495_p(pos.func_177984_a());
        Block block = above.func_177230_c();
        if (block instanceof BlockTorch || block instanceof BlockSkull || block instanceof BlockCandle) {
            return state.func_177226_a(CONNECTION, Connection.CONNECTED);
        }

        return state;
    }

    @Override
    public double getHeight(IBlockState state) {
        Connection c = state.func_177229_b(CONNECTION);
        return c == Connection.DISCONNECTED ? 12d / 16d : 1;
    }

    private static final Set<Material> grounds = Sets.newHashSet(Material.field_151577_b, Material.field_151595_p, Material.field_151578_c, Material.field_151597_y);

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        Material material = worldIn.func_180495_p(pos.func_177977_b()).func_185904_a();
        return grounds.contains(material);
    }

    @Nullable
    @Override
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return Block.field_185506_k;
    }


}
