package betterwithmods.common.blocks;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.List;

/**
 * Created by primetoxinz on 6/24/17.
 */
public abstract class BlockRotate extends BWMBlock {
    public BlockRotate(Material material) {
        super(material);
    }

    @Override
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a("tooltip.rotate_with_hand.name"));
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    public abstract void nextState(World world, BlockPos pos, IBlockState state);

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {

        boolean emptyHands = player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && player.func_184586_b(EnumHand.OFF_HAND).func_190926_b() && player.func_70093_af();

        if (emptyHands) {
            world.func_184133_a(null, pos, this.getSoundType(state, world, pos, player).func_185841_e(), SoundCategory.BLOCKS, 1.0F, world.field_73012_v.nextFloat() * 0.1F + 0.9F);
            nextState(world, pos, state);
            world.func_175685_c(pos, this, false);
            world.func_180497_b(pos, this, 10, 5);
            return true;
        }
        return false;
    }
}
