package betterwithmods.common.blocks;

import betterwithmods.api.IMultiLocations;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import java.util.ArrayList;

/**
 * Created by blueyu2 on 11/19/16.
 */
public class BlockRawPastry extends Block implements IMultiLocations {
    public static final PropertyEnum<BlockRawPastry.EnumType> VARIANT = PropertyEnum.func_177709_a("variant", BlockRawPastry.EnumType.class);

    public BlockRawPastry() {
        super(Material.field_151568_F);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, EnumType.CAKE));
        this.func_149711_c(0.1F);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149647_a(BWCreativeTabs.BWTAB);
    }

    public static ItemStack getStack(EnumType type) {
        return new ItemStack(BWMBlocks.RAW_PASTRY, 1, type.getMetadata());
    }

    @Override
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType type : EnumType.VALUES) {
            items.add(getStack(type));
        }
    }

    @Override
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.NORMAL;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return state.func_177229_b(VARIANT).getMetadata();
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, VARIANT);
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.canBlockStay(worldIn, pos);
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return state.func_177229_b(VARIANT).getAABB();
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(VARIANT).getMetadata();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, EnumType.byMetadata(meta));
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid(worldIn, pos, EnumFacing.UP);
    }

    @Override
    public String[] getLocations() {
        ArrayList<String> variants = new ArrayList<>();
        for (EnumType variant : EnumType.values()) {
            variants.add(variant.func_176610_l());
        }
        return variants.toArray(new String[variants.size()]);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.DOWN ? BlockFaceShape.UNDEFINED : BlockFaceShape.CENTER;
    }

    public enum EnumType implements IStringSerializable {
        CAKE(0, "raw_cake", new AxisAlignedBB(0.0625D, 0.0D, 0.0625D, 0.9375D, 0.5D, 0.9375D)),
        PUMPKIN(1, "raw_pumpkin_pie", new AxisAlignedBB(0.0625D, 0.0D, 0.0625D, 0.9375D, 0.5D, 0.9375D)),
        COOKIE(2, "raw_cookie", new AxisAlignedBB(0.1875D, 0.0D, 0.1875D, 0.8125D, 0.0625D, 0.8125D)),
        BREAD(3, "raw_flour", new AxisAlignedBB(0.25D, 0.0D, 0.0625D, 0.75D, 0.375D, 0.9375D)),
        APPLE(4, "raw_apple_pie", new AxisAlignedBB(0.0625D, 0.0D, 0.0625D, 0.9375D, 0.5D, 0.9375D));

        private static final BlockRawPastry.EnumType[] VALUES = values();

        private final int meta;
        private final String name;
        private final AxisAlignedBB aabb;

        EnumType(int metaIn, String nameIn, AxisAlignedBB aabbIn) {
            this.meta = metaIn;
            this.name = nameIn;
            this.aabb = aabbIn;
        }

        public static BlockRawPastry.EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= VALUES.length) {
                meta = 0;
            }

            return VALUES[meta];
        }

        public int getMetadata() {
            return this.meta;
        }

        @Override
        public String func_176610_l() {
            return this.name;
        }

        public AxisAlignedBB getAABB() {
            return this.aabb;
        }

        public String toString() {
            return this.name;
        }
    }
}
