package betterwithmods.common.blocks;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import net.minecraft.block.BlockRailDetector;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import java.util.List;
import java.util.Optional;
import java.util.Set;

public class BlockRailDetectorBase extends BlockRailDetector {

    private Predicate<Entity> filter;

    public BlockRailDetectorBase(Predicate<Entity> cart) {
        this.filter = cart;
        func_149711_c(0.7F);
        func_149672_a(SoundType.field_185852_e);
    }

    public static boolean isRider(Entity entity, Predicate<Entity> rider) {
        if (entity instanceof EntityMinecart) {
            EntityMinecart cart = (EntityMinecart) entity;
            Optional<Entity> riding = cart.func_184188_bt().stream().findFirst();
            if(riding.isPresent()) {
                return rider.apply(riding.orElse(null));
            }
        }
        return false;
    }

    @Override
    protected <T extends EntityMinecart> List<T> func_176571_a(World worldIn, BlockPos pos, Class<T> clazz, Predicate<Entity>... filters) {
        AxisAlignedBB axisalignedbb = this.getDectectionBox(pos);
        Set<Predicate<Entity>> p = Sets.newHashSet(filters);
        p.add(this.filter);
        return worldIn.func_175647_a(clazz, axisalignedbb, entity -> p.stream().anyMatch(f -> f.apply(entity)));
    }

    private AxisAlignedBB getDectectionBox(BlockPos pos) {
        return new AxisAlignedBB((double) ((float) pos.func_177958_n() + 0.2F), (double) pos.func_177956_o(), (double) ((float) pos.func_177952_p() + 0.2F), (double) ((float) (pos.func_177958_n() + 1) - 0.2F), (double) ((float) (pos.func_177956_o() + 1) - 0.2F), (double) ((float) (pos.func_177952_p() + 1) - 0.2F));
    }
}
