package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.registry.crafting.IngredientTool;
import betterwithmods.util.InvUtils;
import betterwithmods.util.StackIngredient;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.Lists;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.*;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.Arrays;
import java.util.Random;

import static betterwithmods.common.blocks.BlockPlanter.EnumType.*;

public class BlockPlanter extends BWMBlock implements IMultiVariants, IGrowable {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a("plantertype", EnumType.class);

    public BlockPlanter() {
        super(Material.field_151576_e);
        this.func_149675_a(true);
        this.func_149711_c(1.0F);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, EMPTY));
        this.setHarvestLevel("pickaxe", 0);
    }

    public static ItemStack getStack(EnumType type) {
        return new ItemStack(BWMBlocks.PLANTER, 1, type.getMeta());
    }

    @Override
    public String[] getVariants() {
        return new String[]{"plantertype=empty", "plantertype=farmland", "plantertype=grass", "plantertype=soul_sand", "plantertype=fertile", "plantertype=sand", "plantertype=water_still", "plantertype=gravel", "plantertype=red_sand", "plantertype=dirt"};
    }

    public int colorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
        return (state.func_177229_b(TYPE) == GRASS && tintIndex > -1) ? world != null && pos != null ? BiomeColorHelper.func_180286_a(world, pos) : ColorizerGrass.func_77480_a(0.5D, 1.0D) : -1;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return state.func_177229_b(TYPE).getMeta();
    }

    private EnumType getTypeFromStack(ItemStack stack) {
        for (EnumType type : EnumType.VALUES) {
            if (type.apply(stack)) {
                return type;
            }
        }
        return null;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = PlayerHelper.getHolding(player, hand);
        EnumType type = world.func_180495_p(pos).func_177229_b(TYPE);

        EnumType newType = getTypeFromStack(heldItem);
        switch (type) {
            case EMPTY:
                if (newType != null && newType != EMPTY && newType != FARMLAND && newType != FERTILE) {
                    if (world.field_72995_K)
                        return true;
                    if (player.func_184812_l_() || InvUtils.usePlayerItem(player, EnumFacing.UP, heldItem, 1)) {
                        world.func_184133_a(null, pos, newType == WATER ? SoundEvents.field_187624_K : newType.getState().func_177230_c().getSoundType(state, world, pos, player).func_185841_e(), SoundCategory.BLOCKS, 1.0F, world.field_73012_v.nextFloat() * 0.1F + 0.9F);
                        player.func_184609_a(hand);
                        return world.func_175656_a(pos, state.func_177226_a(TYPE, newType));
                    }
                }
                break;
            case WATER:
                if (heldItem.func_77969_a(new ItemStack(Items.field_151133_ar))) {
                    if (world.field_72995_K)
                        return true;
                    if (InvUtils.usePlayerItem(player, EnumFacing.UP, heldItem, 1))
                        InvUtils.givePlayer(player, EnumFacing.UP, InvUtils.asNonnullList(new ItemStack(Items.field_151131_as)));
                    player.func_184609_a(hand);
                    world.func_184133_a(null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0F, world.field_73012_v.nextFloat() * 0.1F + 0.9F);
                    world.func_175656_a(pos, state.func_177226_a(TYPE, EMPTY));
                }
                break;

            case GRASS:
            case DIRT:
                if (newType == FERTILE) {
                    ItemDye.applyBonemeal(heldItem, world, pos, player, hand);
                }
                if (newType == FARMLAND) {
                    heldItem.func_77972_a(1, player);
                    player.func_184609_a(hand);
                    world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0F, 1.0F);
                    world.func_175656_a(pos, state.func_177226_a(TYPE, newType));
                    break;
                }
            case SOULSAND:
                break;
            case FERTILE:
                break;
            case FARMLAND:
                if (newType == FERTILE) {
                    if (world.field_72995_K)
                        return true;
                    if (InvUtils.usePlayerItem(player, EnumFacing.UP, heldItem, 1)) {
                        world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.25F, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7F + 1.0F) * 2.0F);
                        world.func_175656_a(pos, state.func_177226_a(TYPE, newType));
                        world.func_175718_b(2005, pos.func_177984_a(), 0);
                    }
                    break;
                }
            case SAND:
            case GRAVEL:
            case REDSAND:
                if (newType == EMPTY) {
                    if (!player.func_184812_l_()) {
                        InvUtils.givePlayer(player, EnumFacing.UP, InvUtils.asNonnullList(BWMRecipes.getStackFromState(type.getState())));
                    }
                    heldItem.func_77972_a(1, player);
                    world.func_184133_a(null, pos, type.getState().func_177230_c().getSoundType(state, world, pos, player).func_185845_c(), SoundCategory.BLOCKS, 1.0F, world.field_73012_v.nextFloat() * 0.1F + 0.9F);
                    world.func_175656_a(pos, state.func_177226_a(TYPE, newType));
                }
                break;
        }
        return false;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            EnumType type = world.func_180495_p(pos).func_177229_b(TYPE);
            BlockPos up = pos.func_177984_a();
            if (world.func_175623_d(up)) {
                switch (type) {
                    case DIRT:
                        if (world.func_175699_k(up) > 8) {
                            int xP = rand.nextInt(3) - 1;
                            int yP = rand.nextInt(3) - 1;
                            int zP = rand.nextInt(3) - 1;
                            BlockPos checkPos = pos.func_177982_a(xP, yP, zP);
                            if (world.func_180495_p(checkPos).func_177230_c() == Blocks.field_150349_c)
                                world.func_175656_a(pos, this.func_176223_P().func_177226_a(TYPE, GRASS));
                        }
                        break;
                    case GRASS:
                        if (rand.nextInt(100) == 0) {
                            world.func_180494_b(pos).plantFlower(world, rand, up);
                            if (world.func_175699_k(up) > 8) {
                                for (int i = 0; i < 4; i++) {
                                    int xP = rand.nextInt(3) - 1;
                                    int yP = rand.nextInt(3) - 1;
                                    int zP = rand.nextInt(3) - 1;
                                    BlockPos checkPos = pos.func_177982_a(xP, yP, zP);
                                    if (world.func_180495_p(checkPos) == Blocks.field_150346_d && world.func_180495_p(checkPos) == Blocks.field_150346_d.func_176223_P())
                                        world.func_175656_a(checkPos, Blocks.field_150349_c.func_176223_P());
                                }
                            }
                        }
                    case FERTILE:
                        if (world.func_180495_p(up).func_177230_c() instanceof IPlantable) {
                            IPlantable plant = (IPlantable) world.func_180495_p(up).func_177230_c();
                            if (this.canSustainPlant(world.func_180495_p(pos), world, pos, EnumFacing.UP, plant) && world.func_180495_p(up).func_177230_c().func_149653_t()) {
                                IBlockState cropState = world.func_180495_p(up);
                                world.func_180495_p(up).func_177230_c().func_180650_b(world, up, cropState, rand);
                                world.func_180495_p(up).func_177230_c().func_180650_b(world, up, cropState, rand);
                                if (rand.nextInt(100) == 0)
                                    world.func_175656_a(pos, this.func_176223_P().func_177226_a(TYPE, EnumType.DIRT));
                            }
                        }
                        break;
                }
            }
        }
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean isFertile(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177229_b(TYPE) == EnumType.FERTILE;
    }

    @Override
    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing dir, IPlantable plant) {
        BlockPos up = pos.func_177984_a();
        EnumPlantType plantType = plant.getPlantType(world, up);
        return dir == EnumFacing.UP && world.func_180495_p(pos).func_177229_b(TYPE).isType(plantType);
    }

    @Override
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType type : EnumType.VALUES)
            items.add(getStack(type));
    }

    @Override
    public void onPlantGrow(IBlockState state, World world, BlockPos pos, BlockPos source) {
        if (state.func_177229_b(TYPE) == GRASS && source.func_177956_o() == pos.func_177956_o() + 1)
            world.func_175656_a(pos, state.func_177226_a(TYPE, EnumType.DIRT));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, TYPE);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, EnumType.byMeta(meta));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(TYPE).getMeta();
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face != EnumFacing.UP)
            return face == EnumFacing.DOWN ? BlockFaceShape.CENTER_BIG : BlockFaceShape.UNDEFINED;
        switch (state.func_177229_b(TYPE)) {
            case EMPTY:
            case WATER:
                return BlockFaceShape.BOWL;
            default:
                return BlockFaceShape.SOLID;
        }
    }

    @Override
    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return state.func_177229_b(TYPE) == GRASS;
    }

    @Override
    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return func_176473_a(worldIn, pos, state, worldIn.field_72995_K);
    }

    @Override
    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        //Borrowed from BlockGrass
        BlockPos blockpos = pos.func_177984_a();

        for (int i = 0; i < 128; ++i) {
            BlockPos blockpos1 = blockpos;
            int j = 0;

            while (true) {
                if (j >= i / 16) {
                    if (worldIn.func_175623_d(blockpos1)) {
                        if (rand.nextInt(8) == 0) {
                            worldIn.func_180494_b(blockpos1).plantFlower(worldIn, rand, blockpos1);
                        } else {
                            IBlockState iblockstate1 = Blocks.field_150329_H.func_176223_P().func_177226_a(BlockTallGrass.field_176497_a, BlockTallGrass.EnumType.GRASS);

                            if (Blocks.field_150329_H.func_180671_f(worldIn, blockpos1, iblockstate1)) {
                                worldIn.func_180501_a(blockpos1, iblockstate1, 3);
                            }
                        }
                    }

                    break;
                }

                blockpos1 = blockpos1.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1);

                if (worldIn.func_180495_p(blockpos1.func_177977_b()).func_177230_c() != Blocks.field_150349_c || worldIn.func_180495_p(blockpos1).func_185915_l()) {
                    break;
                }

                ++j;
            }
        }
    }

    public enum EnumType implements IStringSerializable {
        EMPTY("empty", new IngredientTool("shovel"), Blocks.field_150350_a.func_176223_P(), 0, new EnumPlantType[0]),
        FARMLAND("farmland", new IngredientTool(s -> s.func_77973_b() instanceof ItemHoe, ItemStack.field_190927_a), Blocks.field_150346_d.func_176223_P(), 1, new EnumPlantType[]{EnumPlantType.Crop, EnumPlantType.Plains}),
        GRASS("grass", StackIngredient.fromStacks(new ItemStack(Blocks.field_150349_c)), Blocks.field_150349_c.func_176223_P(), 2, new EnumPlantType[]{EnumPlantType.Plains}),
        SOULSAND("soul_sand", StackIngredient.fromStacks(new ItemStack(Blocks.field_150425_aM)), Blocks.field_150425_aM.func_176223_P(), 3, new EnumPlantType[]{EnumPlantType.Nether}),
        FERTILE("fertile", StackIngredient.fromStacks(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b())), Blocks.field_150346_d.func_176223_P(), 4, new EnumPlantType[]{EnumPlantType.Crop, EnumPlantType.Plains}),
        SAND("sand", StackIngredient.fromStacks(new ItemStack(Blocks.field_150354_m)), Blocks.field_150354_m.func_176223_P(), 5, new EnumPlantType[]{EnumPlantType.Desert, EnumPlantType.Beach}),
        WATER("water_still", StackIngredient.fromStacks(new ItemStack(Items.field_151131_as)), Blocks.field_150355_j.func_176223_P(), 6, new EnumPlantType[]{EnumPlantType.Water}),
        GRAVEL("gravel", StackIngredient.fromStacks(new ItemStack(Blocks.field_150351_n)), Blocks.field_150351_n.func_176223_P(), 7, new EnumPlantType[]{EnumPlantType.Cave}),
        REDSAND("red_sand", StackIngredient.fromStacks(new ItemStack(Blocks.field_150354_m, 1, BlockSand.EnumType.RED_SAND.func_176688_a())), Blocks.field_150354_m.func_176223_P().func_177226_a(BlockSand.field_176504_a, BlockSand.EnumType.RED_SAND), 8, new EnumPlantType[]{EnumPlantType.Desert, EnumPlantType.Beach}),
        DIRT("dirt", StackIngredient.fromStacks(new ItemStack(Blocks.field_150346_d)), Blocks.field_150346_d.func_176223_P(), 9, new EnumPlantType[]{EnumPlantType.Plains});

        private static final EnumType[] VALUES = values();

        private String name;
        private IBlockState state;
        private int meta;
        private EnumPlantType[] type;
        private Ingredient ingredient;

        EnumType(String name, Ingredient ingredient, IBlockState state, int meta, EnumPlantType[] type) {
            this.name = name;
            this.ingredient = ingredient;
            this.state = state;
            this.meta = meta;
            this.type = type;
        }

        public static EnumType byMeta(int meta) {
            return VALUES[meta];
        }

        @Override
        public String func_176610_l() {
            return name;
        }

        public int getMeta() {
            return meta;
        }

        public boolean isType(EnumPlantType type) {
            return this.type.length != 0 && Arrays.asList(this.type).contains(type);
        }

        public IBlockState getState() {
            return state;
        }

        public boolean apply(ItemStack stack) {
            return ingredient.apply(stack);
        }

        public ItemStack getStack() {
            return Lists.newArrayList(ingredient.func_193365_a()).stream().findFirst().orElse(ItemStack.field_190927_a);
        }
    }
}
