package betterwithmods.common.blocks;

import betterwithmods.util.DirUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by primetoxinz on 6/27/17.
 */
public class BlockPane extends BWMBlock {
    private final Map<PropertyBool, AxisAlignedBB> bounds = new HashMap<PropertyBool, AxisAlignedBB>() {{
        put(DirUtils.NORTH, new AxisAlignedBB(0.4375F, 0.0F, 0.0F, 0.5625F, 1.0F, 0.5625F));
        put(DirUtils.SOUTH, new AxisAlignedBB(0.4375F, 0.0F, 0.4375F, 0.5625F, 1.0F, 1.0F));
        put(DirUtils.WEST, new AxisAlignedBB(0.0F, 0.0F, 0.4375F, 0.5625F, 1.0F, 0.5625F));
        put(DirUtils.EAST, new AxisAlignedBB(0.4375F, 0.0F, 0.4375F, 1.0F, 1.0F, 0.5625F));
    }};

    public BlockPane(Material material) {
        super(material);
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean pass) {
        state = state.func_185899_b(world, pos);

        float minY = 0.001F;
        float maxY = 0.999F;
        float minX = 0.4375F;
        float maxX = 0.5625F;
        float minZ = 0.4375F;
        float maxZ = 0.5625F;
        if (state.func_177229_b(DirUtils.NORTH))
            minZ = 0.0F;
        if (state.func_177229_b(DirUtils.SOUTH))
            maxZ = 1.0F;
        if (state.func_177229_b(DirUtils.WEST))
            minX = 0.0F;
        if (state.func_177229_b(DirUtils.EAST))
            maxX = 1.0F;

        AxisAlignedBB stick = new AxisAlignedBB(0.5F - 0.0625F, 0.0F, 0.5F - 0.0625F, 0.5625F, 1.0F, 0.5625F);
        func_185492_a(pos, entityBox, collidingBoxes, stick);

        if (minZ == 0.0F || maxZ == 1.0F) {
            AxisAlignedBB extZ = new AxisAlignedBB(0.4375F, minY, minZ, 0.5625F, maxY, maxZ);
            func_185492_a(pos, entityBox, collidingBoxes, extZ);
        }

        if (minX == 0.0F || maxX == 1.0F) {
            AxisAlignedBB extX = new AxisAlignedBB(minX, minY, 0.4375F, maxX, maxY, 0.5625F);
            func_185492_a(pos, entityBox, collidingBoxes, extX);
        }
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_185899_b(world, pos);
        AxisAlignedBB bound = new AxisAlignedBB(0.4375F, 0.0F, 0.4375F, 0.5625F, 1.0F, 0.5625F);
        for (PropertyBool dir : DirUtils.DIR_PROP_HORIZ)
            if (state.func_177229_b(dir))
                bound = bound.func_111270_a(bounds.get(dir));
        return bound;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public final boolean isIncompatibleBlock(Block block) {
        return false;
    }

    public final boolean isFenceGate(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        IBlockState state = world.func_180495_p(pos.func_177972_a(dir));
        if (dir == EnumFacing.EAST || dir == EnumFacing.WEST)
            return state.func_177230_c() instanceof BlockFenceGate && (state.func_177229_b(BlockHorizontal.field_185512_D) == EnumFacing.NORTH || state.func_177229_b(BlockHorizontal.field_185512_D) == EnumFacing.SOUTH);
        else
            return state.func_177230_c() instanceof BlockFenceGate && (state.func_177229_b(BlockHorizontal.field_185512_D) == EnumFacing.EAST || state.func_177229_b(BlockHorizontal.field_185512_D) == EnumFacing.WEST);
    }

    public boolean isCompatiblePane(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        BlockPos neighbor = pos.func_177972_a(dir);
        Block block = world.func_180495_p(neighbor).func_177230_c();
        return block instanceof BlockPane;
    }

    public boolean canConnectTo(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        return isFenceGate(world, pos, dir) || isCompatiblePane(world, pos, dir) || world.isSideSolid(pos.func_177972_a(dir),dir.func_176734_d(),true);
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean north = canConnectTo(world, pos, EnumFacing.NORTH);
        boolean east = canConnectTo(world, pos, EnumFacing.EAST);
        boolean south = canConnectTo(world, pos, EnumFacing.SOUTH);
        boolean west = canConnectTo(world, pos, EnumFacing.WEST);
        return state.func_177226_a(DirUtils.NORTH, north).func_177226_a(DirUtils.EAST, east).func_177226_a(DirUtils.SOUTH, south).func_177226_a(DirUtils.WEST, west);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE_THIN : BlockFaceShape.CENTER_SMALL;
    }
}
