package betterwithmods.common.blocks;

import betterwithmods.api.IMultiLocations;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.damagesource.BWDamageSource;
import betterwithmods.common.items.tools.ItemSoulforgeArmor;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.Lists;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.*;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;
import java.util.List;
import java.util.Random;

/**
 * Created by primetoxinz on 6/25/17.
 */
public class BlockNetherGrowth extends BWMBlock implements IMultiLocations {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a("age", 0, 7);

    public BlockNetherGrowth() {
        super(Material.field_151577_b);
        func_149675_a(true);
        func_180632_j(func_176223_P().func_177226_a(AGE, 0));
        func_149711_c(0.5f);
        func_149752_b(0.1f);

    }


    public int getAge(IBlockState state) {
        return state.func_177229_b(AGE);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack held = playerIn.func_184614_ca();
        if (!held.func_77969_a(BlockUrn.getStack(BlockUrn.EnumType.FULL, 1)))
            return false;
        if (!world.field_72995_K) {

            Iterable<BlockPos> pool = BlockPos.PooledMutableBlockPos.func_177980_a(pos.func_177982_a(-3, -3, -3), pos.func_177982_a(3, 3, 3));
            boolean grew = false;
            for (BlockPos p : pool) {
                IBlockState s = world.func_180495_p(p);
                if (s != null && s.func_177230_c() == BWMBlocks.NETHER_GROWTH) {
                    BlockNetherGrowth b = (BlockNetherGrowth) s.func_177230_c();
                    for (int i = 0; i < 10; i++)
                        b.grow(world, p, s, world.field_73012_v);
                    grew = true;
                }
            }
            if (grew) {
                held.func_190918_g(1);
            }
        }
        return true;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {

        Random rand = world.field_73012_v;
        for (int i = 0; i < 9; i++) {
            this.spread(world, pos, rand);
        }

        AxisAlignedBB bb = this.func_185496_a(state, world, pos).func_186670_a(pos).func_186662_g(3);
        List<Entity> entities = world.func_72872_a(Entity.class, bb);
        for (Entity e : entities) {
            e.func_70097_a(BWDamageSource.growth, 2);
        }
        world.func_184133_a(null, pos, SoundEvents.field_187882_fq, SoundCategory.BLOCKS, 0.4f, 0.5f);

        super.func_180663_b(world, pos, state);
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        checkCanStay(worldIn, pos);
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        grow(worldIn, pos, state, rand);
    }

    private int range(Random rand) {
        return rand.nextInt(3) - 1;
    }

    public void grow(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            checkCanStay(world, pos);
            int age = getAge(state);
            if (age > 3) {
                spread(world, pos, rand);
            }
            if (age < 7) {
                if (age == 6)
                    world.func_184133_a(null, pos, SoundEvents.field_187540_ab, SoundCategory.BLOCKS, 0.2f, 0.5f);
                world.func_175656_a(pos, state.func_177226_a(AGE, age + 1));
                fixEntities(world, pos, state);
            }
        }
    }

    public void spread(World world, BlockPos pos, Random rand) {

        BlockPos spread = pos.func_177982_a(range(rand), range(rand), range(rand));
        if (func_176196_c(world, spread) && !spread.equals(pos)) {
            world.func_175656_a(spread, func_176223_P());
        }
    }

    private void fixEntities(World world, BlockPos pos, IBlockState state) {
        AxisAlignedBB bb = this.func_185496_a(state, world, pos).func_186670_a(pos).func_186662_g(1 / 16d);
        List<Entity> entities = world.func_72872_a(Entity.class, bb);
        for (Entity e : entities) {
            e.func_70107_b(e.field_70165_t, e.field_70163_u + 4 / 16d, e.field_70161_v);
        }
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, AGE);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int age = getAge(state) + 1;
        return new AxisAlignedBB(0, 0, 0, 1, age / 16d, 1);
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return SoundType.field_185859_l;
    }


    @Override
    public String[] getLocations() {
        return new String[]{"nether_spore"};
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return getAge(state);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return func_176223_P().func_177226_a(AGE, meta);
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        //NO DROPS
        return Lists.newArrayList();
    }

    @Override
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(10) == 0) {
            worldIn.func_175688_a(EnumParticleTypes.TOWN_AURA, (double) ((float) pos.func_177958_n() + rand.nextFloat()), (double) ((float) pos.func_177956_o() + 1.1F), (double) ((float) pos.func_177952_p() + rand.nextFloat()), 0.0D, 0.0D, 0.0D, new int[0]);
        }
    }

    @Override
    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityItem) {
            ItemStack stack = ((EntityItem) entityIn).func_92059_d();
            if (stack.func_77973_b() instanceof ItemFood) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187739_dZ, SoundCategory.BLOCKS, 1.0f, 0.2f);
                grow(worldIn, pos, state, worldIn.field_73012_v);
                entityIn.func_70106_y();
            }
        } else if (entityIn instanceof EntityLivingBase) {
            if (PlayerHelper.hasPart((EntityLivingBase) entityIn, EntityEquipmentSlot.FEET, ItemSoulforgeArmor.class))
                return;
            entityIn.func_70097_a(BWDamageSource.growth, 5);
            entityIn.field_70143_R = 0;
            entityIn.field_70181_x = 1;
        }
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_175623_d(pos) && canStay(worldIn, pos);
    }

    public void checkCanStay(World world, BlockPos pos) {
        if (!canStay(world, pos)) {
            func_180663_b(world, pos, world.func_180495_p(pos));
            world.func_175698_g(pos);
        }
    }

    public boolean canStay(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return block == Blocks.field_150424_aL || block == Blocks.field_150449_bY;
    }

    @Override
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.DOWN ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    @SideOnly(Side.CLIENT)
    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

}
