package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.module.tweaks.MushroomFarming;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import java.util.Random;

public class BlockMushroom extends net.minecraft.block.BlockMushroom {
    int maxLightLevel;

    public BlockMushroom(int maxLightLevel) {
        super();
        this.maxLightLevel = maxLightLevel;
        func_149711_c(0.0F);
        func_149672_a(SoundType.field_185850_c);
        func_149663_c("mushroom");
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        if(worldIn.func_175699_k(pos) <= maxLightLevel || MushroomFarming.SPREAD_ON_MYCELLIUM && MushroomFarming.isMushroomSoil(soil)) {
            int growthChance = MushroomFarming.GROW_FAST_ON_DUNG && isDung(soil) ? 12 : 25;
            if (rand.nextInt(growthChance) == 0) {
                int max_mushrooms = 5;
                int tries = 4;

                for (BlockPos checkpos : BlockPos.func_177975_b(pos.func_177982_a(-4, -1, -4), pos.func_177982_a(4, 1, 4))) {
                    if (worldIn.func_180495_p(checkpos).func_177230_c() == this) {
                        --max_mushrooms;

                        if (max_mushrooms <= 0) {
                            return;
                        }
                    }
                }

                BlockPos grow_pos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);

                for (int k = 0; k < tries; ++k) {
                    if (worldIn.func_175623_d(grow_pos) && this.func_180671_f(worldIn, grow_pos, this.func_176223_P())) {
                        pos = grow_pos;
                    }

                    grow_pos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
                }

                if (worldIn.func_175623_d(grow_pos) && this.func_180671_f(worldIn, grow_pos, this.func_176223_P())) {
                    worldIn.func_180501_a(grow_pos, this.func_176223_P(), 3);
                }
            }
        }
    }

    private boolean isDung(IBlockState state)
    {
        return state.func_177230_c() == BWMBlocks.AESTHETIC && state.func_177229_b(BlockAesthetic.TYPE) == BlockAesthetic.EnumType.DUNG;
    }

    @Override
    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state)
    {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256)
        {
            IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());

            if(MushroomFarming.isMushroomSoil(soil))
                return true;
            else
                return worldIn.func_175699_k(pos) <= maxLightLevel && soil.func_177230_c().canSustainPlant(soil, worldIn, pos.func_177977_b(), EnumFacing.UP, this);
        }
        else
        {
            return false;
        }
    }
}
