package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.util.DirUtils;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;

public class BlockMultiPane extends BlockPane implements IMultiVariants {
    public static final PropertyEnum<EnumPaneType> TYPES = PropertyEnum.func_177709_a("type", EnumPaneType.class);

    public BlockMultiPane() {
        super(Material.field_151575_d);
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_149711_c(2.0F);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPES, EnumPaneType.OAK).func_177226_a(DirUtils.NORTH, false).func_177226_a(DirUtils.EAST, false).func_177226_a(DirUtils.SOUTH, false).func_177226_a(DirUtils.WEST, false));
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Override
    public String[] getVariants() {
        String[] var = new String[BlockPlanks.EnumType.values().length];
        for (int i = 0; i < var.length; i++) {
            var[i] = "east=false,north=true,south=true,type=" + BlockPlanks.EnumType.func_176837_a(i) + ",west=false";
        }
        return var;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return state.func_177229_b(TYPES).getMeta();
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(TYPES).getMeta();
    }

    @Override
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumPaneType type : EnumPaneType.values()) {
            items.add(new ItemStack(this, 1, type.getMeta()));
        }
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPES, EnumPaneType.byMeta(meta));
    }

    @Override
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, TYPES, DirUtils.SOUTH, DirUtils.EAST, DirUtils.NORTH, DirUtils.WEST);
    }

    public enum EnumPaneType implements IStringSerializable {
        OAK(0, "oak"),
        SPRUCE(1, "spruce"),
        BIRCH(2, "birch"),
        JUNGLE(3, "jungle"),
        ACACIA(4, "acacia"),
        DARK_OAK(5, "dark_oak");

        private static final EnumPaneType[] META_LOOKUP = new EnumPaneType[values().length];

        static {
            for (EnumPaneType type : values()) {
                META_LOOKUP[type.getMeta()] = type;
            }
        }

        private String name;
        private int meta;

        EnumPaneType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static EnumPaneType byMeta(int meta) {
            return META_LOOKUP[meta];
        }

        @Override
        public String func_176610_l() {
            return name;
        }

        public int getMeta() {
            return meta;
        }
    }
}
