package betterwithmods.common.blocks;

import betterwithmods.common.entity.EntityMiningCharge;
import betterwithmods.util.DirUtils;
import jline.internal.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

/**
 * Created by primetoxinz on 9/5/16.
 */

public class BlockMiningCharge extends BlockTNT {
    private static final AxisAlignedBB D_AABB = new AxisAlignedBB(0, .5, 0, 1, 1, 1);
    private static final AxisAlignedBB U_AABB = new AxisAlignedBB(0, 0, 0, 1, .5, 1);
    private static final AxisAlignedBB N_AABB = new AxisAlignedBB(0, 0, .5, 1, 1, 1);
    private static final AxisAlignedBB S_AABB = new AxisAlignedBB(0, 0, 0, 1, 1, .5);
    private static final AxisAlignedBB W_AABB = new AxisAlignedBB(.5, 0, 0, 1, 1, 1);
    private static final AxisAlignedBB E_AABB = new AxisAlignedBB(0, 0, 0, .5, 1, 1);

    public BlockMiningCharge() {
        func_149672_a(SoundType.field_185850_c);
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = state.func_177229_b(DirUtils.FACING);
        switch (facing) {
            case DOWN://DOWN
                return D_AABB;
            case UP://UP
                return U_AABB;
            case NORTH:
                return N_AABB;
            case SOUTH:
                return S_AABB;
            case WEST:
                return W_AABB;
            case EAST:
                return E_AABB;
            default:
                return field_185505_j;
        }

    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, field_176246_a, DirUtils.FACING);
    }

    @Override
    public void func_180692_a(World worldIn, BlockPos pos, IBlockState state, @Nullable EntityLivingBase igniter) {
        if (!worldIn.field_72995_K && state.func_177229_b(field_176246_a)) {
            EntityMiningCharge miningCharge = new EntityMiningCharge(worldIn, (double) ((float) pos.func_177958_n() + 0.5F), (double) pos.func_177956_o(), (double) ((float) pos.func_177952_p() + 0.5F), igniter, getFacing(state));
            worldIn.func_72838_d(miningCharge);
            worldIn.func_184148_a(null, miningCharge.field_70165_t, miningCharge.field_70163_u, miningCharge.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0F, 1.0F);
        }
    }

    public EnumFacing getFacing(IBlockState state) {
        return state.func_177229_b(DirUtils.FACING);
    }

    @Override
    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return func_176223_P().func_177226_a(DirUtils.FACING, facing);
    }

    @Override
    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return worldIn.isSideSolid(pos.func_177972_a(side.func_176734_d()), side);
    }

    @Override
    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        if (worldIn.func_175640_z(pos)) {
            this.func_176206_d(worldIn, pos, state.func_177226_a(field_176246_a, true));
            worldIn.func_175698_g(pos);
        }
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos other) {
        if (worldIn.func_175640_z(pos)) {
            this.func_176206_d(worldIn, pos, state.func_177226_a(field_176246_a, true));
            worldIn.func_175698_g(pos);
        }
    }

    @Override
    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        func_180652_a(world, pos, explosion);
        world.func_175698_g(pos);
    }

    @Override
    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (!worldIn.field_72995_K) {
            EntityMiningCharge miningCharge = new EntityMiningCharge(worldIn, (double) ((float) pos.func_177958_n() + 0.5F), (double) pos.func_177956_o(), (double) ((float) pos.func_177952_p() + 0.5F), explosionIn.func_94613_c(), getFacing(worldIn.func_180495_p(pos)));
            miningCharge.setFuse((short) (worldIn.field_73012_v.nextInt(miningCharge.getFuse() / 4) + miningCharge.getFuse() / 8));
            worldIn.func_72838_d(miningCharge);
        }
    }

    @Override
    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        this.func_180692_a(worldIn, pos, state, null);
    }

    @Override
    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!worldIn.field_72995_K && entityIn instanceof EntityArrow) {
            EntityArrow entityarrow = (EntityArrow) entityIn;
            if (entityarrow.func_70027_ad()) {
                EntityLivingBase shooter = entityarrow.field_70250_c instanceof EntityLivingBase ? (EntityLivingBase) entityarrow.field_70250_c : null;
                this.func_180692_a(worldIn, pos, worldIn.func_180495_p(pos).func_177226_a(field_176246_a, true), shooter);
                worldIn.func_175698_g(pos);
            }
        }
    }

    @Override
    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        boolean explode = (meta & 1) > 0;
        EnumFacing facing = EnumFacing.func_82600_a(meta >> 1);
        return this.func_176223_P().func_177226_a(field_176246_a, explode).func_177226_a(DirUtils.FACING, facing);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int facing = state.func_177229_b(DirUtils.FACING).func_176745_a() << 1;
        int explode = state.func_177229_b(field_176246_a) ? 1 : 0;
        return explode | facing;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != getFacing(state).func_176734_d() ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

}
