package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.common.BWMBlocks;
import betterwithmods.util.DirUtils;
import com.google.common.collect.Maps;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class BlockLens extends BlockRotate implements IMultiVariants{
    public static final PropertyBool LIT = PropertyBool.func_177716_a("lit");
    public static final int RANGE = 256;

    public BlockLens() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5F);
        this.func_149675_a(true);
        this.func_180632_j(this.func_176223_P().func_177226_a(DirUtils.FACING, EnumFacing.NORTH));
        this.setHarvestLevel("pickaxe", 0);
    }



    @Override
    public int func_149738_a(World world) {
        return 5;
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_180497_b(pos, this, 3, 5);
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase entity, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, entity, hand);
        EnumFacing face = DirUtils.convertEntityOrientationToFacing(entity, side);
        return setFacingInBlock(state, face);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        cleanupLightToFacing(world, pos, state.func_177229_b(DirUtils.FACING));
        super.func_180663_b(world, pos, state);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        EnumFacing facing = DirUtils.convertEntityOrientationToFacing(entity, EnumFacing.NORTH);
        setFacingInBlock(state, facing);
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        world.func_180497_b(pos, this, 3, 5);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        cleanupLight(world, pos);
        EnumFacing dir = getFacing(world, pos);

        boolean isLightDetector = isFacingBlockDetector(world, pos);

        if (!isLightDetector) {
            boolean sunlight = isLightFromSun(world, pos);
            boolean lightOn = isInputLit(world, pos);
            if (isLit(world, pos) != lightOn) {
                setLit(world, pos, lightOn);
            }
            EnumFacing expectedFacing = DirUtils.getOpposite(getFacing(world, pos));

            BlockPos offset = pos.func_177972_a(dir);
            if (isLit(world, pos) && (world.func_175623_d(offset) || world.func_180495_p(offset).func_177230_c() == BWMBlocks.LIGHT_SOURCE)) {
                int currentRange = RANGE;
                for (int i = 1; i < RANGE; i++) {
                    BlockPos bPos = pos.func_177967_a(dir, i);
                    if (!world.func_175623_d(bPos)) {
                        currentRange = i + 1;
                        break;
                    }
                }

                AxisAlignedBB bb = field_185505_j.func_186670_a(pos);
                int mod = dir.func_176743_c().func_179524_a();
                switch(dir.func_176740_k()) {
                    case X:
                        bb = bb.func_72321_a(mod * currentRange,0,0);
                        break;
                    case Y:
                        bb = bb.func_72321_a(0, mod * currentRange,0);
                        break;
                    case Z:
                        bb = bb.func_72321_a(0, 0, mod * currentRange);
                        break;
                }
                List<Entity> box = world.func_72872_a(Entity.class, bb);
                HashMap<Integer, Entity> map = Maps.newHashMap();
                for (Entity e : box) {
                    int distance = 0;
                    switch (dir.func_176740_k()) {
                        case X:
                            distance = (int) (pos.func_177958_n() - e.field_70165_t);
                            break;
                        case Y:
                            distance = (int) (pos.func_177956_o() - e.field_70163_u);
                            break;
                        case Z:
                            distance = (int) (pos.func_177952_p() - e.field_70161_v);
                            break;
                    }
                    map.put(Math.abs(distance), e);
                }


                for (int i = 1; i < currentRange; i++) {
                    BlockPos bPos = pos.func_177967_a(dir, i);
                    IBlockState lightState = BWMBlocks.LIGHT_SOURCE.func_176223_P();
                    if (world.func_175623_d(bPos)) {
                        if (map.containsKey(i)) {
                            world.func_175656_a(bPos, lightState.func_177226_a(DirUtils.FACING, expectedFacing).func_177226_a(BlockInvisibleLight.SUNLIGHT, sunlight));
                            break;
                        } else if (world.func_180495_p(bPos).func_177230_c() == BWMBlocks.LIGHT_SOURCE && world.func_180495_p(bPos).func_177229_b(DirUtils.FACING).ordinal() < expectedFacing.ordinal()) {
                            if (world.func_180495_p(bPos).func_177229_b(BlockInvisibleLight.SUNLIGHT))
                                lightState = lightState.func_177226_a(BlockInvisibleLight.SUNLIGHT, true);
                            world.func_175656_a(bPos, lightState.func_177226_a(DirUtils.FACING, expectedFacing));
                        } else if (!world.func_175623_d(bPos)) {
                            bPos = bPos.func_177972_a(dir.func_176734_d());
                            if (world.func_180495_p(bPos).func_177230_c() != BWMBlocks.LIGHT_SOURCE || (world.func_180495_p(bPos).func_177230_c() == BWMBlocks.LIGHT_SOURCE && world.func_180495_p(bPos).func_177229_b(DirUtils.FACING).ordinal() < expectedFacing.ordinal()))
                                world.func_175656_a(bPos, lightState.func_177226_a(DirUtils.FACING, expectedFacing).func_177226_a(BlockInvisibleLight.SUNLIGHT, sunlight));
                            break;
                        }

                    } else if (!world.func_175623_d(bPos)) {
                        BlockPos dPos = bPos.func_177972_a(dir.func_176734_d());
                        if (world.func_180495_p(dPos).func_177230_c() != BWMBlocks.LIGHT_SOURCE || (world.func_180495_p(dPos).func_177230_c() == BWMBlocks.LIGHT_SOURCE && world.func_180495_p(dPos).func_177229_b(DirUtils.FACING).ordinal() <= expectedFacing.ordinal())) {
                            if (world.func_180495_p(dPos).func_177230_c() == BWMBlocks.LIGHT_SOURCE && world.func_180495_p(dPos).func_177229_b(BlockInvisibleLight.SUNLIGHT))
                                lightState = lightState.func_177226_a(BlockInvisibleLight.SUNLIGHT, sunlight);
                            world.func_175656_a(dPos, lightState.func_177226_a(DirUtils.FACING, expectedFacing));
                        }
                        break;
                    }
                }
            } else if (!isLit(world, pos)) {
                for (int i = 1; i < RANGE; i++) {
                    BlockPos bPos = pos.func_177967_a(dir, i);

                    if (world.func_180495_p(bPos).func_177230_c() == BWMBlocks.LIGHT_SOURCE) {
                        world.func_175698_g(bPos);
                    } else if (!world.func_175623_d(bPos)) {
                        break;
                    }
                }
            }
        } else {
            int lightValue = world.func_175699_k(pos.func_177972_a(dir.func_176734_d()));

            boolean shouldBeOn = lightValue > 7;

            if (isLit(world, pos) != shouldBeOn)
                setLit(world, pos, shouldBeOn);
        }
        world.func_180497_b(pos, this, 5, 5);
    }

    @Override
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        return getFacing(world.func_180495_p(pos));
    }

    public EnumFacing getFacing(IBlockState state) {
        return state.func_177229_b(DirUtils.FACING);
    }

    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.func_177226_a(DirUtils.FACING, facing);
    }

    public boolean isLit(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177229_b(LIT);
    }

    public void setLit(World world, BlockPos pos, boolean isOn) {
        boolean oldLit = world.func_180495_p(pos).func_177229_b(LIT);

        if (isOn != oldLit) {
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a(LIT, isOn));
            world.func_190524_a(pos, this, pos);
        }
    }

    private boolean isInputLit(World world, BlockPos pos) {
        EnumFacing facing = getFacing(world, pos);
        EnumFacing dir = DirUtils.getOpposite(facing);
        BlockPos oppOff = pos.func_177972_a(dir);
        Block block = world.func_180495_p(oppOff).func_177230_c();

        if (world.func_175623_d(oppOff) && world.func_175710_j(oppOff)) {
            return world.func_175642_b(EnumSkyBlock.SKY, oppOff) > 12 && world.func_72935_r() && (!world.func_72896_J() || !world.func_72911_I());
        } else if (block.getLightValue(world.func_180495_p(oppOff), world, oppOff) > 12) {
            return true;
        }
        return false;
    }

    private boolean isFacingBlockDetector(World world, BlockPos pos) {
        EnumFacing facing = getFacing(world, pos);
        BlockPos offset = pos.func_177972_a(facing);
        Block block = world.func_180495_p(offset).func_177230_c();

        if (block == BWMBlocks.DETECTOR) {
            EnumFacing detFacing = ((BlockDetector) block).getFacing(world.func_180495_p(offset));

            if (detFacing == DirUtils.getOpposite(facing))
                return true;
        }
        return false;
    }

    private boolean isLightFromSun(World world, BlockPos pos) {
        EnumFacing facing = DirUtils.getOpposite(getFacing(world, pos));
        BlockPos offset = pos.func_177972_a(facing);
        if (world.func_175623_d(offset) && world.func_175710_j(offset))
            return true;
        else if (world.func_180495_p(offset).func_177230_c() == BWMBlocks.LIGHT_SOURCE && world.func_180495_p(offset).func_177229_b(BlockInvisibleLight.SUNLIGHT))
            return true;
        return false;
    }

    private void cleanupLightToFacing(World world, BlockPos pos, EnumFacing facing) {
        EnumFacing opp = DirUtils.getOpposite(facing);
        for (int i = 1; i < RANGE; i++) {
            BlockPos offset = pos.func_177967_a(facing, i);
            if (world.func_180495_p(offset).func_177230_c() == BWMBlocks.LIGHT_SOURCE) {
                EnumFacing lightFace = ((BlockInvisibleLight) world.func_180495_p(offset).func_177230_c()).getFacing(world, offset);
                if (lightFace == opp) {
                    world.func_175698_g(offset);
                    break;
                }
            } else if (!world.func_175623_d(offset))
                break;
        }
    }

    private void cleanupLight(World world, BlockPos pos) {
        EnumFacing facing = getFacing(world, pos);
        EnumFacing oppFacing = DirUtils.getOpposite(facing);

        for (int i = 1; i < RANGE; i++) {
            BlockPos offset = pos.func_177967_a(facing, i);

            if (world.func_180495_p(offset).func_177230_c() == BWMBlocks.LIGHT_SOURCE) {
                EnumFacing lightFace = ((BlockInvisibleLight) world.func_180495_p(offset).func_177230_c()).getFacing(world, offset);
                if (lightFace == oppFacing) {
                    world.func_175698_g(offset);
                }
            } else if (!world.func_175623_d(offset)) {
                if (world.func_180495_p(offset).func_177230_c() == this) {
                    BlockLens lens = (BlockLens) world.func_180495_p(pos).func_177230_c();
                    if (lens.getFacing(world, offset) == facing)
                        break;
                }
            }
        }
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        boolean lit = false;
        if (meta > 7) {
            lit = true;
            meta -= 8;
        }
        return this.func_176223_P().func_177226_a(LIT, lit).func_177226_a(DirUtils.FACING, EnumFacing.func_82600_a(meta));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = state.func_177229_b(LIT) ? 8 : 0;
        return meta + state.func_177229_b(DirUtils.FACING).func_176745_a();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, DirUtils.FACING, LIT);
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a(LIT, false).func_177231_a(DirUtils.FACING));
    }

    @Override
    public String[] getVariants() {
        return new String[]{"facing=north,lit=false"};
    }

}
