package betterwithmods.common.blocks;

import betterwithmods.api.block.PropertyObject;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.blocks.tile.TileKiln;
import betterwithmods.common.registry.KilnStructureManager;
import betterwithmods.common.registry.heat.BWMHeatRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

import javax.annotation.Nullable;
import java.util.Random;

public class BlockKiln extends BWMBlock {
    public static final PropertyInteger COOK = PropertyInteger.func_177719_a("cook", 0, 8);
    public static final PropertyObject<IBlockState> HELD_STATE = new PropertyObject<>("held_state", IBlockState.class);
    public static final PropertyObject<IBlockAccess> HELD_WORLD = new PropertyObject<>("held_world", IBlockAccess.class);
    public static final PropertyObject<BlockPos> HELD_POS = new PropertyObject<>("held_pos", BlockPos.class);

    public BlockKiln() {
        super(Material.field_151576_e);
        this.func_149675_a(true);
        this.func_149711_c(2.0F);
        this.func_149752_b(10.0F);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public int func_149738_a(World world) {
        return 20;
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_180497_b(pos, this, 20, 5);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!KilnStructureManager.isValidKiln(world, pos)) {
            IExtendedBlockState extendedBlockState = (IExtendedBlockState) getExtendedState(state, world, pos);
            if (state instanceof IExtendedBlockState) {
                IBlockState held_state = extendedBlockState.getValue(HELD_STATE);
                if (held_state != null) {
                    world.func_175713_t(pos);
                    world.func_175656_a(pos, held_state);
                    return;
                }
            }
            world.func_175698_g(pos);
            return;
        }

        BlockPos craftPos = pos.func_177984_a();
        if (!world.func_175623_d(craftPos)) {
            TileKiln tile = getTile(world, pos);
            if (tile != null) {
                tile.kiln(world, craftPos, rand);
            }
        }
    }

    public int calculateTickRate(World world, BlockPos pos) {
        int secondaryFire = 0;
        int centerFire = BWMHeatRegistry.getHeat(world, pos.func_177977_b());
        for (int xP = -1; xP < 2; xP++) {
            for (int zP = -1; zP < 2; zP++) {
                BlockPos bPos = pos.func_177982_a(xP, -1, zP);
                int currentFire = BWMHeatRegistry.getHeat(world, bPos);
                if (currentFire == centerFire)
                    secondaryFire += currentFire;
            }
        }
        return Math.max(0, Math.max(0, 60 * (8 - Math.max(secondaryFire, 0))) / 8 + 20);
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        world.func_180497_b(pos, this, 20, 5);
    }


    public int getCookCounterFromMeta(int meta) {
        return meta & 0x7;
    }

    public int getCookCounter(IBlockAccess world, BlockPos pos) {
        return getCookCounterFromMeta(world.func_180495_p(pos).func_177229_b(COOK));
    }

    public void setCookCounter(World world, BlockPos pos, int cookCounter) {
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a(COOK, cookCounter));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(COOK, meta);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(COOK);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState(this, new IProperty[]{COOK}, new IUnlistedProperty[]{HELD_WORLD, HELD_POS, HELD_STATE});
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = ((IExtendedBlockState) state).withProperty(HELD_WORLD, world)
                .withProperty(HELD_POS, pos);
        TileEntity te = world instanceof ChunkCache ? ((ChunkCache) world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (te instanceof TileKiln) {
            TileKiln tile = (TileKiln) te;
            IExtendedBlockState camo = ((IExtendedBlockState) state).withProperty(HELD_STATE, tile.camoState);
            return camo;
        } else {
            return state;
        }
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileKiln();
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState) getExtendedState(state,world,pos);
        return BWMRecipes.getStackFromState(extendedBlockState.getValue(HELD_STATE));
    }

    public TileKiln getTile(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileKiln)
            return (TileKiln) tile;
        return null;
    }
}
