package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.util.DirUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.List;
import java.util.Random;

public class BlockInvisibleLight extends BWMBlock {
    public static final PropertyBool SUNLIGHT = PropertyBool.func_177716_a("sunlight");

    public BlockInvisibleLight() {
        super(Material.field_151579_a);
        this.func_149715_a(1.0F);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SUNLIGHT, false).func_177226_a(DirUtils.FACING, EnumFacing.UP));
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Override
    public int func_149738_a(World world) {
        return 6;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_175684_a(pos, this, 5);
    }

    @Override
    public int func_149745_a(Random rand) {
        return 0;
    }

    @Override
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @Override
    public boolean func_176209_a(IBlockState state, boolean playerActivated) {
        return false;
    }

    @Override
    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    @Override
    public void func_180653_a(World world, BlockPos pos, IBlockState state, float f, int fortune) {
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        if (world.func_180495_p(pos).func_177230_c() == BWMBlocks.LIGHT_SOURCE)
            world.func_175698_g(pos);
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K) {
            if (world.func_180495_p(pos).func_177229_b(SUNLIGHT)) {
                if (entity instanceof EntityLiving) {
                    EntityLiving living = (EntityLiving) entity;
                    if (living.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
                        living.func_70015_d(4);
                    }
                }
            }
        }
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!hasClearViewToLens(world, pos)) {
            world.func_175698_g(pos);
        } else
            world.func_175684_a(pos, this, 5);
    }

    public EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177229_b(DirUtils.FACING);
    }

    public EnumFacing getFacing(IBlockState state) {
        return state.func_177229_b(DirUtils.FACING);
    }

    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.func_177226_a(DirUtils.FACING, facing);
    }

    private boolean hasClearViewToLens(World world, BlockPos pos) {
        boolean clear = true;
        EnumFacing face = getFacing(world.func_180495_p(pos));
        for (int i = 1; i < 32; i++)//64 default, try to get some lag solved
        {
            BlockPos bPos = pos.func_177967_a(face, i);
            int x = bPos.func_177958_n();
            int y = bPos.func_177956_o();
            int z = bPos.func_177952_p();
            List<Entity> entity = world.func_72872_a(Entity.class, new AxisAlignedBB(x, y, z, x + 1, y + 1, z + 1));
            if (entity.size() > 0)
                clear = false;
            else if (world.func_180495_p(bPos).func_177230_c() == BWMBlocks.LIGHT_SOURCE)
                clear = false;
            else if (world.func_180495_p(bPos).func_177230_c() == BWMBlocks.LENS) {
                BlockLens lens = (BlockLens) world.func_180495_p(bPos).func_177230_c();
                return lens.getFacing(world, bPos) == DirUtils.getOpposite(getFacing(world, bPos));
            } else if (!world.func_175623_d(bPos))
                clear = false;
            if (!clear)
                break;
        }
        return clear;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        boolean sun = false;
        if (meta > 7) {
            sun = true;
            meta -= 8;
        }
        return this.func_176223_P().func_177226_a(SUNLIGHT, sun).func_177226_a(DirUtils.FACING, EnumFacing.func_82600_a(meta));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = state.func_177229_b(SUNLIGHT) ? 8 : 0;
        return meta + state.func_177229_b(DirUtils.FACING).func_176745_a();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, DirUtils.FACING, SUNLIGHT);
    }
}
