package betterwithmods.common.blocks;

import betterwithmods.BWMod;
import betterwithmods.client.BWGuiHandler;
import betterwithmods.common.blocks.tile.TileEntityInfernalEnchanter;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

/**
 * Created by primetoxinz on 9/11/16.
 */
public class BlockInfernalEnchanter extends BWMBlock implements ITileEntityProvider {

    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a("active");

    public BlockInfernalEnchanter() {
        super(Material.field_151573_f);
        func_149711_c(5.0F);
        func_149752_b(2000.0F);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, ACTIVE);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(ACTIVE) ? 1 : 0;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return func_176223_P().func_177226_a(ACTIVE, meta == 1);
    }

    @Override
    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if(state.func_177229_b(ACTIVE))
            return 15;
        return super.getLightValue(state, world, pos);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0, 0, 0, 1, 0.5d, 1);
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityInfernalEnchanter();
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        } else {
            if (worldIn.func_175625_s(pos) != null) {
                playerIn.openGui(BWMod.instance, BWGuiHandler.Gui.TILE.ordinal(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing facing) {
        return facing == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        world.func_184133_a(null, pos, SoundEvents.field_187557_bK, SoundCategory.BLOCKS, 1, 1);
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
    }

    @Override
    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149730_j(IBlockState state) {
        return false;
    }
}
