package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import java.util.Random;

public class BlockHibachi extends BWMBlock {
    public static final PropertyBool LIT = PropertyBool.func_177716_a("lit");

    public BlockHibachi() {
        super(Material.field_151576_e);
        this.func_149675_a(true);
        this.func_149711_c(3.5F);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(LIT, false));
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public int func_149738_a(World world) {
        return 4;
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_180497_b(pos, this, func_149738_a(world), 5);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        boolean powered = world.func_175687_A(pos) > 0;

        if (powered) {
            if (!isLit(world, pos))
                ignite(world, pos);
            else {
                Block above = world.func_180495_p(pos.func_177984_a()).func_177230_c();
                if (above != Blocks.field_150480_ab && above != BWMBlocks.STOKED_FLAME) {
                    if (shouldIgnite(world, pos.func_177984_a())) {
                        world.func_184133_a(null, pos, SoundEvents.field_187557_bK, SoundCategory.BLOCKS, 1.0F, world.field_73012_v.nextFloat() * 0.4F + 0.8F);
                        world.func_175656_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                    }
                }
            }
        } else if (isLit(world, pos))
            extinguish(world, pos);
        else {
            Block above = world.func_180495_p(pos.func_177984_a()).func_177230_c();

            if (above == Blocks.field_150480_ab || above == BWMBlocks.STOKED_FLAME)
                world.func_175698_g(pos.func_177984_a());
        }
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        if (!isCurrentlyValid(world, pos))
            world.func_180497_b(pos, this, func_149738_a(world), 5);
    }

    @Override
    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return world.func_180495_p(pos).func_177229_b(LIT) && side == EnumFacing.UP;
    }

    public boolean isCurrentlyValid(World world, BlockPos pos) {
        boolean powered = world.func_175687_A(pos) > 0;
        if (isLit(world, pos) != powered)
            return false;
        if (isLit(world, pos)) {
            Block block = world.func_180495_p(pos).func_177230_c();

            if (block != Blocks.field_150480_ab && block != BWMBlocks.STOKED_FLAME) {
                if (shouldIgnite(world, pos.func_177984_a()))
                    return false;
            }
        }
        return true;
    }

    public boolean isLit(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177229_b(LIT);
    }

    private boolean shouldIgnite(World world, BlockPos pos) {
        if (world.func_175623_d(pos))
            return true;
        if (world.func_180495_p(pos).func_177230_c().isFlammable(world, pos, EnumFacing.DOWN))
            return true;
        Block block = world.func_180495_p(pos).func_177230_c();
        Material material = world.func_180495_p(pos).func_185904_a();

        if (!material.func_76230_c() && material != Material.field_151587_i && material != Material.field_151586_h) {
            if (!(block instanceof BlockDoor))
                return true;
        }
        return false;
    }

    private void ignite(World world, BlockPos pos) {
        setLit(world, pos);
        world.func_184133_a(null, pos, SoundEvents.field_187557_bK, SoundCategory.BLOCKS, 1.0F, world.field_73012_v.nextFloat() * 0.4F + 1.0F);

        if (shouldIgnite(world, pos.func_177984_a()))
            world.func_175656_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
    }

    private void extinguish(World world, BlockPos pos) {
        clearLit(world, pos);

        world.func_184133_a(null, pos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 0.5F, 2.6F + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8F);

        boolean isFire = world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150480_ab || world.func_180495_p(pos.func_177984_a()).func_177230_c() == BWMBlocks.STOKED_FLAME;

        if (isFire)
            world.func_175698_g(pos.func_177984_a());
    }

    private void setLit(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, state.func_177226_a(LIT, true));
    }

    private void clearLit(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, state.func_177226_a(LIT, false));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        boolean isLit = meta == 1;
        return this.func_176223_P().func_177226_a(LIT, isLit);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(LIT) ? 1 : 0;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, LIT);
    }
}
