package betterwithmods.common.blocks;

import betterwithmods.api.IMultiLocations;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;


public class BlockHemp extends BlockCrops implements IPlantable, IMultiLocations {
    public static final PropertyBool TOP = PropertyBool.func_177716_a("top");
    private static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{
            new AxisAlignedBB(3 / 16d, 0.0D, 3 / 16d, 13 / 16d, 0.125D, 13 / 16d),
            new AxisAlignedBB(3 / 16d, 0.0D, 3 / 16d, 13 / 16d, 0.25D, 13 / 16d),
            new AxisAlignedBB(3 / 16d, 0.0D, 3 / 16d, 13 / 16d, 0.375D, 13 / 16d),
            new AxisAlignedBB(3 / 16d, 0.0D, 3 / 16d, 13 / 16d, 0.5d, 13 / 16d),
            new AxisAlignedBB(3 / 16d, 0.0D, 3 / 16d, 13 / 16d, 0.625D, 13 / 16d),
            new AxisAlignedBB(3 / 16d, 0.0D, 3 / 16d, 13 / 16d, 0.75D, 13 / 16d),
            new AxisAlignedBB(3 / 16d, 0.0D, 3 / 16d, 13 / 16d, 0.875D, 13 / 16d),
            new AxisAlignedBB(3 / 16d, 0.0D, 3 / 16d, 13 / 16d, 1.0D, 13 / 16d)};

    public static double growthChance, lampModifier, fertileModifier, neighborModifier;

    public BlockHemp() {
        super();
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_180632_j(func_176223_P().func_177226_a(TOP, false));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB[state.func_177229_b(this.func_185524_e())];
    }


    @Override
    public String[] getLocations() {
        return new String[]{"hemp_seed"};
    }

    @Override
    public boolean func_185525_y(IBlockState state) {
        return state.func_177229_b(TOP) || state.func_177229_b(field_176488_a) > 6;
    }

    @Override
    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        IBlockState above = worldIn.func_180495_p(pos.func_177984_a());
        return !state.func_177229_b(TOP) && !(above.func_177230_c() instanceof BlockHemp);
    }

    @Override
    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        return (world.func_175699_k(pos) > 12 || world.func_175678_i(pos) || world.func_175678_i(pos.func_177984_a()) || isBelowLightBlock(world, pos)) && (canBePlantedHere(world, pos) || canPlantGrowOnBlock(world.func_180495_p(pos.func_177977_b())));
    }

    private boolean isBelowLightBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockLight || world.func_180495_p(pos.func_177981_b(2)).func_177230_c() instanceof BlockLight;
    }

    public boolean canBePlantedHere(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c().canSustainPlant(world.func_180495_p(pos.func_177977_b()), world, pos.func_177977_b(), EnumFacing.UP, this);
    }

    @Override
    public void func_176487_g(World worldIn, BlockPos pos, IBlockState state) {
        if (!state.func_177229_b(TOP) && state.func_177229_b(field_176488_a) >= 7) {
            worldIn.func_175656_a(pos.func_177984_a(), state.func_177226_a(TOP, true));
        }
        super.func_176487_g(worldIn, pos, state);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        func_176475_e(world, pos, state);
        BlockPos up = pos.func_177984_a();

        int age = state.func_177229_b(field_176488_a);
        boolean isTop = state.func_177229_b(TOP);

        double growthChance = BlockHemp.growthChance;

        if (world.func_180495_p(pos.func_177981_b(2)).func_177230_c() instanceof BlockLight && world.func_175623_d(pos.func_177984_a())) {
            if (world.func_180495_p(pos.func_177981_b(2)).func_177229_b(BlockLight.ACTIVE))
                growthChance /= lampModifier;
        }
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c().isFertile(world, pos.func_177977_b()))
            growthChance /= fertileModifier;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            IBlockState check = world.func_180495_p(pos.func_177972_a(facing));
            if (check.func_177230_c() == this)
                growthChance /= neighborModifier;
        }
        if (age < 7) {
            if (world.func_175671_l(up) > 12) {
                if (rand.nextInt(MathHelper.func_76128_c(growthChance)) == 0)
                    world.func_175656_a(pos, state.func_177226_a(field_176488_a, age + 1));
            }
        } else if (age == 7 && world.func_175623_d(up) && !isTop) {
            if (world.func_175671_l(up) > 12) {
                if (rand.nextInt(MathHelper.func_76128_c(growthChance*growthChance)) == 0)
                    world.func_175656_a(up, state.func_177226_a(field_176488_a, 7).func_177226_a(TOP, true));
            }
        }
    }

    @Override
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(this, 1, 0);
    }

    private boolean canPlantGrowOnBlock(IBlockState state) {
        Block block = state.func_177230_c();
        return block == this && state.func_177229_b(field_176488_a) == 7;
    }

    @Override
    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    @Override
    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    @Override
    protected void func_176475_e(World world, BlockPos pos, IBlockState state) {
        if (!func_180671_f(world, pos, state)) {
            func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    @Override
    public int func_180651_a(IBlockState state) {
        int meta = state.func_177229_b(field_176488_a);
        return meta > 6 ? 2 : 0;
    }

    @Override
    protected Item func_149866_i() {
        return Item.func_150898_a(BWMBlocks.HEMP);
    }

    @Override
    protected Item func_149865_P() {
        return BWMItems.MATERIAL;
    }

    @Override
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, field_176488_a, TOP);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        if (meta == 8)
            return super.func_176203_a(7).func_177226_a(TOP, true);
        return super.func_176203_a(meta).func_177226_a(TOP, false);
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List<ItemStack> ret = new ArrayList<>();
        int age = func_185527_x(state);
        Random rand = world instanceof World ? ((World) world).field_73012_v : new Random();

        ret.add(new ItemStack(this.func_180660_a(state, rand, fortune), 1, this.func_180651_a(state)));

        if (age >= func_185526_g()) {
            int count = 1 + fortune;
            if (state.func_177229_b(TOP)) {
                if (rand.nextInt(2 * func_185526_g()) <= age)
                    ret.add(new ItemStack(this.func_149866_i(), count));
            } else {
                ret.add(new ItemStack(this.func_149866_i(), 1));
            }
        }
        return ret;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        if (state.func_177229_b(TOP))
            return 8;
        return super.func_176201_c(state);
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int meta = state.func_177229_b(field_176488_a);
        return meta > 6 ? this.func_149865_P() : this.func_149866_i();
    }


}
