package betterwithmods.common.blocks;

import betterwithmods.client.BWCreativeTabs;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public abstract class BlockFurniture extends BWMBlock {
    public static final PropertyBool SUPPORTED = PropertyBool.func_177716_a("supported");
    protected static final AxisAlignedBB BENCH_AABB = new AxisAlignedBB(0.0D, 0.375D, 0.0D, 1.0D, 0.5D, 1.0D);
    protected static final AxisAlignedBB BENCH_STAND_AABB = new AxisAlignedBB(0.375D, 0.0D, 0.375D, 0.625D, 0.375D, 0.625D);
    protected static final AxisAlignedBB TABLE_AABB = new AxisAlignedBB(0.0D, 0.875D, 0.0D, 1.0D, 1.0D, 1.0D);
    protected static final AxisAlignedBB TABLE_STAND_AABB = new AxisAlignedBB(0.375D, 0.0D, 0.375D, 0.625D, 0.875D, 0.625D);
    protected static final AxisAlignedBB HALF_BLOCK_AABB = new AxisAlignedBB(0.0D, 0.0D, 0.0D, 1.0D, 0.5D, 1.0D);

    public BlockFurniture(Material material) {
        super(material);
        this.func_149711_c(3.5F);
        this.func_149647_a(BWCreativeTabs.BWTAB);
    }


    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 6; i++) {
            ItemStack stack = new ItemStack(this, 1, i);
            list.add(stack);
        }
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean connected = isConnected(state, world, pos, EnumFacing.NORTH) || isConnected(state, world, pos, EnumFacing.WEST);
        return state.func_177226_a(SUPPORTED, connected);
    }

    private boolean isConnected(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        EnumFacing opp = facing.func_176734_d();
        IBlockState state1 = world.func_180495_p(pos.func_177972_a(facing));
        IBlockState state2 = world.func_180495_p(pos.func_177972_a(opp));
        return state1.func_177230_c().canBeConnectedTo(world,pos.func_177972_a(facing),opp) && state2.func_177230_c().canBeConnectedTo(world,pos.func_177972_a(opp),facing);
    }
}
