package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.registry.KilnStructureManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import java.util.Random;

public class BlockFireStoked extends BlockFire {
    public BlockFireStoked() {
        super();
        this.func_149649_H();
        this.func_149715_a(1.0F);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(field_176543_a, 0).func_177226_a(field_176545_N, Boolean.FALSE).func_177226_a(field_176546_O, Boolean.FALSE).func_177226_a(field_176541_P, Boolean.FALSE).func_177226_a(field_176539_Q, Boolean.FALSE).func_177226_a(field_176542_R, Boolean.FALSE));
    }

    @Override
    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.func_70015_d(40);
    }

    @Override
    public int func_149738_a(World world) {
        return 52;
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_180497_b(pos, this, func_149738_a(world), 5);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!func_176196_c(world, pos))
            world.func_175698_g(pos);

        BlockPos below = pos.func_177977_b();
        Block belowBlock = world.func_180495_p(below).func_177230_c();

        if (belowBlock == BWMBlocks.HIBACHI) {
            if (!belowBlock.isFireSource(world, below, EnumFacing.UP))
                world.func_175698_g(pos);
        } else {
            world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            return;
        }
        BlockPos above = pos.func_177984_a();

        KilnStructureManager.createKiln(world,above);
        
        if (world.func_180495_p(pos).func_177230_c() == BWMBlocks.STOKED_FLAME) { //Attempt at alleviating an OptiFine crash
            int meta = world.func_180495_p(pos).func_177229_b(field_176543_a);

            if (meta < 15) {
                meta++;
                world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a(field_176543_a, meta));
            }

            boolean flag1 = world.func_180502_D(pos);

            this.setFire(world, pos.func_177974_f(), 300, rand, meta, EnumFacing.WEST);
            this.setFire(world, pos.func_177976_e(), 300, rand, meta, EnumFacing.EAST);
            this.setFire(world, pos.func_177977_b(), 250, rand, meta, EnumFacing.UP);
            this.setFire(world, pos.func_177984_a(), 250, rand, meta, EnumFacing.DOWN);
            this.setFire(world, pos.func_177978_c(), 300, rand, meta, EnumFacing.SOUTH);
            this.setFire(world, pos.func_177968_d(), 300, rand, meta, EnumFacing.NORTH);
            for (int i1 = -1; i1 <= 1; ++i1) {
                for (int j1 = 1; j1 <= 1; ++j1) {
                    for (int k1 = 1; k1 <= 4; ++k1) {
                        int l1 = 100;
                        if (k1 > 1) {
                            l1 += (k1 - (1)) * 100;
                        }
                        BlockPos blockpos = pos.func_177982_a(i1, k1, j1);
                        int i2 = this.func_176538_m(world, blockpos);
                        if (i2 > 0) {
                            int j2 = (i2 + 40 + world.func_175659_aa().func_151525_a() * 7) / (meta + 30);
                            if (flag1) {
                                j2 /= 2;
                            }
                            if (j2 > 0 && rand.nextInt(l1) <= j2 && (!world.func_72896_J() || !this.func_176537_d(world, blockpos))) {
                                int k2 = meta + rand.nextInt(5) / 4;
                                if (k2 > 15) {
                                    k2 = 15;
                                }
                                world.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P().func_177226_a(field_176543_a, k2));
                            }
                        }
                    }
                }
            }

            if (meta >= 3) {
                world.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P().func_177226_a(field_176543_a, 15), 3);
                return;
            }

            world.func_180497_b(pos, this, func_149738_a(world) + world.field_73012_v.nextInt(10), 5);
        }
    }

    public int func_176538_m(World worldIn, BlockPos pos)
    {
        if (!worldIn.func_175623_d(pos))
        {
            return 0;
        }
        else
        {
            int i = 0;

            for (EnumFacing enumfacing : EnumFacing.values())
            {
                i = Math.max(worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c().getFireSpreadSpeed(worldIn, pos.func_177972_a(enumfacing), enumfacing.func_176734_d()), i);
            }

            return i;
        }
    }


    private void setFire(World worldIn, BlockPos pos, int chance, Random random, int age, EnumFacing face) {
        int i = worldIn.func_180495_p(pos).func_177230_c().getFlammability(worldIn, pos, face);

        if (random.nextInt(chance) < i) {
            IBlockState iblockstate = worldIn.func_180495_p(pos);

            if (random.nextInt(age + 10) < 5 && !worldIn.func_175727_C(pos)) {
                int j = age + random.nextInt(5) / 4;

                if (j > 15) {
                    j = 15;
                }

                worldIn.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P().func_177226_a(field_176543_a, j), 3);
            } else {
                worldIn.func_175698_g(pos);
            }

            if (iblockstate.func_177230_c() == Blocks.field_150335_W) {
                Blocks.field_150335_W.func_176206_d(worldIn, pos, iblockstate.func_177226_a(BlockTNT.field_176246_a, true));
            }
        }
    }

    @Override
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, field_176543_a, field_176545_N, field_176546_O, field_176541_P, field_176539_Q, field_176542_R);
    }
}
