package betterwithmods.common.blocks;

import net.minecraft.block.BlockFarmland;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

import java.util.Random;

public class BlockFertileFarmland extends BlockFarmland {
    public BlockFertileFarmland() {
        super();
        this.func_149711_c(0.6F);
        this.func_149672_a(SoundType.field_185849_b);
        this.setHarvestLevel("shovel", 0);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);

        IBlockState above = world.func_180495_p(pos.func_177984_a());
        if (above.func_177230_c() instanceof IPlantable && canSustainPlant(above, world, pos, EnumFacing.UP, (IPlantable) above.func_177230_c())) {
            world.func_180497_b(pos.func_177984_a(), above.func_177230_c(), above.func_177230_c().func_149738_a(world), 5);
            if (rand.nextInt(150) == 0) {
                int meta = this.func_176201_c(state);
                world.func_175656_a(pos, Blocks.field_150458_ak.func_176223_P().func_177226_a(field_176531_a, meta & 7));
            }
        }
    }

    @Override
    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return plantable.getPlantType(world, pos.func_177984_a()) == EnumPlantType.Crop || plantable.getPlantType(world, pos.func_177984_a()) == EnumPlantType.Plains;
    }
}
