package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.common.BWMItems;
import betterwithmods.module.tweaks.GrassPath;
import betterwithmods.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.*;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import static net.minecraft.block.BlockDirt.SNOWY;

/**
 * @author Koward
 */
public class BlockDirtSlab extends BlockSimpleSlab implements IMultiVariants {
    public static final PropertyEnum<DirtSlabType> VARIANT = PropertyEnum.func_177709_a("variant", BlockDirtSlab.DirtSlabType.class);
    private static final EnumFacing[] CHECKED_FACINGS_FOR_SNOW = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};

    public BlockDirtSlab() {
        super(Material.field_151578_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, DirtSlabType.DIRT).func_177226_a(field_176385_b, false));
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149675_a(true);
        this.setHarvestLevel("shovel", 0);
    }

    @Override
    public boolean func_149710_n(IBlockState state) {
        return true;
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(this, 1, 0);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b(VARIANT) == DirtSlabType.PATH)
            return new AxisAlignedBB(0, 0, 0, 1, 7 / 16d, 1);
        return super.func_185496_a(state, source, pos);
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack held = playerIn.func_184586_b(hand);
        if (state.func_177229_b(VARIANT) != DirtSlabType.PATH && GrassPath.getShovelQuality(held) > 1) {
            worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0F, 1.0F);
            playerIn.func_184609_a(hand);
            if (!worldIn.field_72995_K) {
                worldIn.func_180501_a(pos, state.func_177226_a(VARIANT, DirtSlabType.PATH), 11);
                held.func_77972_a(1, playerIn);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return isOverSupport(worldIn, pos);
    }

    private boolean isOverSupport(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        return state.func_177230_c() == Blocks.field_185774_da || state.isSideSolid(worldIn, pos.func_177977_b(), EnumFacing.UP)
                || state.func_177230_c().canPlaceTorchOnTop(state, worldIn, pos.func_177977_b())
                || state.func_185915_l()
                || state.func_185917_h()
                || state.func_185913_b();
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos other) {
        if (!isOverSupport(worldIn, pos)) {
            worldIn.func_175655_b(pos, false);
            func_180635_a(worldIn, pos, new ItemStack(BWMItems.DIRT_PILE));
        }
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List<ItemStack> drops = new ArrayList<>();
        drops.add(new ItemStack(this));
        return drops;
    }

    @Override
    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (state.func_177229_b(VARIANT)).getColor();
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177229_b(VARIANT) == DirtSlabType.PATH)
            return state;
        boolean snowy = false;
        for (EnumFacing facing : CHECKED_FACINGS_FOR_SNOW) {
            BlockPos checkedPos = pos.func_177972_a(facing);
            Block block = worldIn.func_180495_p(checkedPos).func_177230_c();
            Block blockOver = worldIn.func_180495_p(checkedPos.func_177984_a()).func_177230_c();
            if (block == Blocks.field_150433_aE || block == Blocks.field_150431_aC ||
                    blockOver == Blocks.field_150433_aE || blockOver == Blocks.field_150431_aC) {
                snowy = true;
            }
        }
        state = state.func_177226_a(field_176385_b, snowy);

        return state;
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add(new ItemStack(this, 1, DirtSlabType.DIRT.getMetadata()));
        list.add(new ItemStack(this, 1, DirtSlabType.GRASS.getMetadata()));
        list.add(new ItemStack(this, 1, DirtSlabType.MYCELIUM.getMetadata()));
    }

    @Override
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this, 1, state.func_177229_b(VARIANT).getMetadata());
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, DirtSlabType.byMetadata(meta));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(VARIANT).getMetadata();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, VARIANT, field_176385_b);
    }

    @Override
    public Material func_149688_o(IBlockState state) {
        return state.func_177229_b(VARIANT).getMaterial();
    }

    @SideOnly(Side.CLIENT)
    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public String[] getVariants() {
        ArrayList<String> variants = new ArrayList<>();
        for (DirtSlabType enumtype : DirtSlabType.values()) {
            variants.add("snowy=false,variant=" + enumtype.func_176610_l());
        }
        return variants.toArray(new String[DirtSlabType.values().length]);
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (state.func_177229_b(field_176385_b)) return SoundType.field_185856_i;
        switch (state.func_177229_b(VARIANT)) {
            case DIRT:
                return SoundType.field_185849_b;
            case GRASS:
            case MYCELIUM:
            default:
                return SoundType.field_185850_c;
        }

    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        switch (blockState.func_177229_b(VARIANT)) {
            case DIRT:
                return 0.5F;
            case GRASS:
            case MYCELIUM:
            default:
                return 0.6F;
        }
    }

    private void handleSubtypeChange(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            int shrinkLight = WorldUtils.getNaturalLightFromNeighbors(world, pos.func_177984_a());
            int growthLight = shrinkLight - world.func_175657_ab();
            BlockPos check = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
            Block block = world.func_180495_p(check).func_177230_c();
            if (block == Blocks.field_150349_c || (block == this && world.func_180495_p(check).func_177229_b(VARIANT) == DirtSlabType.GRASS)) {
                if (growthLight >= 11)
                    world.func_175656_a(pos, state.func_177226_a(VARIANT, DirtSlabType.GRASS));
            } else if (block == Blocks.field_150391_bh || (block == this && world.func_180495_p(check).func_177229_b(VARIANT) == DirtSlabType.MYCELIUM)) {
                if (growthLight >= 9)
                    world.func_175656_a(pos, state.func_177226_a(VARIANT, DirtSlabType.MYCELIUM));
            }
        }
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            if (state.func_177229_b(VARIANT) == DirtSlabType.GRASS) {
                BlockGrassCustom.handleGrassSpreading(worldIn, pos, rand, func_176223_P().func_177226_a(VARIANT, DirtSlabType.DIRT));
            } else if (state.func_177229_b(VARIANT) == DirtSlabType.MYCELIUM) {
                BlockMyceliumCustom.handleMyceliumSpreading(worldIn, pos, rand, func_176223_P().func_177226_a(VARIANT, DirtSlabType.DIRT));
            } else if (state.func_177229_b(VARIANT) == DirtSlabType.DIRT)
                handleSubtypeChange(worldIn, pos, state, rand);
        }
    }

    @SideOnly(Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        if (!(stateIn.func_177229_b(VARIANT) == DirtSlabType.MYCELIUM)) {
            return;
        }

        if (rand.nextInt(10) == 0) {
            worldIn.func_175688_a(EnumParticleTypes.TOWN_AURA, (double) ((float) pos.func_177958_n() + rand.nextFloat()), (double) ((float) pos.func_177956_o() + 1.1F), (double) ((float) pos.func_177952_p() + rand.nextFloat()), 0.0D, 0.0D, 0.0D);
        }
    }

    public enum DirtSlabType implements IStringSerializable {
        DIRT(0, "dirt", Material.field_151578_c),
        GRASS(1, "grass", Material.field_151577_b),
        MYCELIUM(2, "mycelium", MapColor.field_151678_z, Material.field_151577_b),
        PATH(3, "path", Material.field_151578_c);
        private static final DirtSlabType[] METADATA_LOOKUP = new DirtSlabType[values().length];

        static {
            for (DirtSlabType blockdirt$dirttype : values()) {
                METADATA_LOOKUP[blockdirt$dirttype.getMetadata()] = blockdirt$dirttype;
            }
        }

        private final int metadata;
        private final String name;
        private final MapColor color;
        private final Material material;

        DirtSlabType(int metadataIn, String nameIn, Material material) {
            this(metadataIn, nameIn, material.func_151565_r(), material);
        }

        DirtSlabType(int metadataIn, String nameIn, MapColor color, Material material) {
            this.metadata = metadataIn;
            this.name = nameIn;
            this.color = color;
            this.material = material;
        }

        public static DirtSlabType byMetadata(int metadata) {
            if (metadata < 0 || metadata >= METADATA_LOOKUP.length) {
                metadata = 0;
            }

            return METADATA_LOOKUP[metadata];
        }

        public int getMetadata() {
            return this.metadata;
        }

        public MapColor getColor() {
            return this.color;
        }

        public Material getMaterial() {
            return this.material;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}
