package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.util.DirUtils;
import net.minecraft.block.*;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.List;
import java.util.Random;

public class BlockDetector extends BlockRotate {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a("active");

    public BlockDetector() {
        super(Material.field_151576_e);
        this.func_149711_c(3.5F);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(DirUtils.FACING, EnumFacing.NORTH).func_177226_a(ACTIVE, false));
        this.func_149675_a(true);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public int func_149738_a(World world) {
        return 4;
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase entity, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, entity, hand);
        return setFacingInBlock(state, DirUtils.convertEntityOrientationToFacing(entity, side));
    }


    @Override
    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, @Nullable EnumFacing face, float hitX, float hitY, float hitZ) {
        super.onBlockPlacedBy(world, pos, state, placer, stack, face, hitX, hitY, hitZ);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        EnumFacing facing = DirUtils.convertEntityOrientationToFacing(entity, EnumFacing.NORTH);
        setFacingInBlock(state, facing);

    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        setBlockOn(world, pos, false);
        world.func_180497_b(pos, this, func_149738_a(world), 5);
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        world.func_180497_b(pos, this, func_149738_a(world), 5);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        setBlockOn(world, pos, detectBlock(world, pos));
    }

    @Override
    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean func_149744_f(IBlockState state) {
        return state.func_177229_b(ACTIVE);
    }

    @Override
    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return isBlockOn(world, pos) ? 15 : 0;
    }

    public EnumFacing getFacing(IBlockState state) {
        return state.func_177229_b(DirUtils.FACING);
    }

    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.func_177226_a(DirUtils.FACING, facing);
    }

    public boolean isBlockOn(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177229_b(ACTIVE);
    }

    public void setBlockOn(World world, BlockPos pos, boolean on) {
        if (on != isBlockOn(world, pos)) {
            IBlockState state = world.func_180495_p(pos).func_177226_a(ACTIVE, on);

            if (on) {
                world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3F, 0.7F);
            }

            world.func_175656_a(pos, state);

            for (int i = 0; i < 6; i++) {
                world.func_190524_a(pos.func_177972_a(EnumFacing.func_82600_a(i)), this, pos);
            }
        }
        world.func_180497_b(pos, this, func_149738_a(world), 5);
    }

    public boolean detectBlock(World world, BlockPos pos) {
        EnumFacing facing = getFacing(world.func_180495_p(pos));
        BlockPos offset = pos.func_177972_a(facing);
        IBlockState blockState = world.func_180495_p(offset);
        Block target = blockState.func_177230_c();

        if (facing == EnumFacing.UP && world.func_175623_d(offset) && (world.getBiomeForCoordsBody(offset).func_76738_d() && world.func_175710_j(offset) && (world.func_72896_J() || world.func_72911_I()))) {
            return true;
        } else if (target == BWMBlocks.LENS) {
            BlockLens lens = (BlockLens) target;
            return lens.getFacing(blockState) == DirUtils.getOpposite(getFacing(world.func_180495_p(pos))) && lens.isLit(world, offset);
        } else if (blockState.func_185904_a().func_76220_a() || target instanceof BlockVine || target instanceof BlockReed) {
            return true;
        } else if (target == BWMBlocks.LIGHT_SOURCE) {
            return blockState.func_177229_b(DirUtils.FACING) == facing;
        } else if (target instanceof BlockHemp) {
            return blockState.func_177229_b(BlockHemp.TOP);
        } else if (world.func_175623_d(offset)) {
            int x = offset.func_177958_n();
            int y = offset.func_177956_o();
            int z = offset.func_177952_p();
            AxisAlignedBB collisionBox = new AxisAlignedBB(x, y, z, x + 1, y + 1, z + 1);
            List<Entity> entityList = world.func_72872_a(Entity.class, collisionBox);
            world.func_180497_b(pos, this, func_149738_a(world), 5);
            if (!entityList.isEmpty())
                return true;
            else {
                //Crops except hemp;

                BlockPos downOffset = offset.func_177977_b();
                IBlockState downState = world.func_180495_p(downOffset);
                Block downBlock = downState.func_177230_c();

                if ( !(downBlock instanceof BlockHemp) && downBlock instanceof BlockCrops) {
                    return ((BlockCrops) downBlock).func_185525_y(downState);
                } else if (downBlock == Blocks.field_150388_bm) {
                    return downState.func_177229_b(BlockNetherWart.field_176486_a) >= 3;
                }
            }
        }
        return false;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        boolean isActive = false;
        if (meta > 7) {
            isActive = true;
            meta -= 8;
        }
        return this.func_176223_P().func_177226_a(ACTIVE, isActive).func_177226_a(DirUtils.FACING, EnumFacing.func_82600_a(meta));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = state.func_177229_b(ACTIVE) ? 8 : 0;
        return meta + state.func_177229_b(DirUtils.FACING).func_176745_a();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, DirUtils.FACING, ACTIVE);
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a(ACTIVE, false).func_177231_a(DirUtils.FACING));
    }
}
