package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWSounds;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class BlockChime extends BWMBlock implements IMultiVariants {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a("active");
    private static final AxisAlignedBB CHIME_AABB = new AxisAlignedBB(0.3125D, 0.375D, 0.3125D, 0.6875D, 0.875D, 0.6875D);

    public BlockChime(Material material) {
        super(material);

        this.func_149711_c(2.0F);
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ACTIVE, false).func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.OAK));
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Override
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a("tooltip.chime.name"));
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    @Override
    public String[] getVariants() {
        ArrayList<String> variants = new ArrayList<>();
        for (BlockPlanks.EnumType blockplanks$enumtype : BlockPlanks.EnumType.values()) {
            variants.add("active=false,variant=" + blockplanks$enumtype.func_176610_l());
        }
        return variants.toArray(new String[BlockPlanks.EnumType.values().length]);
    }

    @Override
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (BlockPlanks.EnumType type : BlockPlanks.EnumType.values()) {
            items.add(new ItemStack(this, 1, type.func_176839_a()));
        }
    }


    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K)
            return true;
        else {
            if (!state.func_177229_b(ACTIVE)) {
                world.func_175656_a(pos, state.func_177226_a(ACTIVE, true));
                world.func_184133_a(null, pos, state.func_185904_a() == Material.field_151573_f ? BWSounds.METALCHIME : BWSounds.WOODCHIME, SoundCategory.BLOCKS, 0.4F, 1.0F);
                for (EnumFacing facing : EnumFacing.field_82609_l)
                    world.func_175685_c(pos.func_177972_a(facing), this, false);
            }
            return true;
        }
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return state.func_177229_b(BlockPlanks.field_176383_a).func_176839_a();
    }

    @Override
    public int func_149738_a(World world) {
        return 20;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()).isSideSolid(world, pos.func_177984_a(), EnumFacing.DOWN) || world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockFence || world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof net.minecraft.block.BlockPane || world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockMultiPane || world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockRope;
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_180497_b(pos, this, func_149738_a(world), 5);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (state.func_177229_b(ACTIVE)) {
            for (EnumFacing facing : EnumFacing.field_82609_l)
                world.func_175685_c(pos.func_177972_a(facing), this, false);
        }
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        if (!func_176196_c(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        } else {
            world.func_180497_b(pos, this, func_149738_a(world), 5);
        }
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CHIME_AABB;
    }

    @Override
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        boolean storm = detectStorming(world, pos) || isEntityColliding(world, pos);
        boolean isActive = state.func_177229_b(ACTIVE);

        if (storm != isActive) {
            world.func_175656_a(pos, state.func_177226_a(ACTIVE, storm));
            world.func_175685_c(pos, this, false);
            for (EnumFacing facing : EnumFacing.field_82609_l)
                world.func_175685_c(pos.func_177972_a(facing), this, false);
        }
        if (storm)
            world.func_184133_a(null, pos, state.func_185904_a() == Material.field_151573_f ? BWSounds.METALCHIME : BWSounds.WOODCHIME, SoundCategory.BLOCKS, 0.25F + (rand.nextFloat() - rand.nextFloat() * 0.1F), 1.0F);
        world.func_180497_b(pos, this, func_149738_a(world), 5);
    }

    private boolean detectStorming(World world, BlockPos pos) {
        return (world.func_72896_J() || world.func_72911_I()) && isNearOpenAir(world, pos);
    }

    private boolean isNearOpenAir(World world, BlockPos pos) {
        for (int x = -5; x < 6; x++) {
            for (int y = -2; y < 4; y++) {
                for (int z = -5; z < 6; z++) {
                    BlockPos check = pos.func_177982_a(x, y, z);
                    if (world.func_175710_j(check))
                        return true;
                }
            }
        }
        return false;
    }

    private boolean isEntityColliding(World world, BlockPos pos) {
        List<Entity> entities = world.func_72872_a(Entity.class, new AxisAlignedBB(pos.func_177958_n() + 0.3125D, pos.func_177956_o() + 0.375D, pos.func_177952_p() + 0.3125D, pos.func_177958_n() + 0.6875D, pos.func_177956_o() + 1.0D, pos.func_177952_p() + 0.6875D));
        return !entities.isEmpty();
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!state.func_177229_b(ACTIVE)) {
            world.func_175656_a(pos, state.func_177226_a(ACTIVE, true));
            world.func_175685_c(pos, this, false);
            for (EnumFacing facing : EnumFacing.field_82609_l)
                world.func_175685_c(pos.func_177972_a(facing), this, false);
            world.func_184133_a(null, pos, state.func_185904_a() == Material.field_151573_f ? BWSounds.METALCHIME : BWSounds.WOODCHIME, SoundCategory.BLOCKS, 1.0F, 1.0F);
        }
    }

    @Override
    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return func_180656_a(state, world, pos, side);
    }

    @Override
    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        if (state.func_177229_b(ACTIVE))
            return 15;
        return 0;
    }

    @Override
    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = state.func_177229_b(BlockPlanks.field_176383_a).func_176839_a();
        return meta + (state.func_177229_b(ACTIVE) ? 8 : 0);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        boolean active = meta > 7;
        if (active)
            meta -= 8;
        return this.func_176223_P().func_177226_a(ACTIVE, active).func_177226_a(BlockPlanks.field_176383_a, BlockPlanks.EnumType.func_176837_a(meta));
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, ACTIVE, BlockPlanks.field_176383_a);
    }
}
