package betterwithmods.common.blocks;

import betterwithmods.api.tile.IRopeConnector;
import betterwithmods.common.blocks.mechanical.tile.TileEntityPulley;
import betterwithmods.common.blocks.tile.TileEntityBucket;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;

public class BlockBucket extends BWMBlock implements IRopeConnector {

    public static final PropertyBool CONNECTED = PropertyBool.func_177716_a("connected");
    public static final PropertyBool IN_WATER = PropertyBool.func_177716_a("in_water");
    public static final PropertyBool HAS_WATER = PropertyBool.func_177716_a("has_water");

    public BlockBucket() {
        super(Material.field_151573_f);
        func_180632_j(func_176223_P().func_177226_a(CONNECTED, true).func_177226_a(IN_WATER, false).func_177226_a(HAS_WATER, false));
        func_149711_c(5.0F);
        func_149752_b(10.0F);
        func_149672_a(SoundType.field_185852_e);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, IN_WATER, HAS_WATER, CONNECTED);
    }

    @Override
    public EnumFacing getFacing(IBlockState state) {
        return EnumFacing.UP;
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return FluidUtil.interactWithFluidHandler(playerIn, hand, worldIn, pos, facing);
    }

    @Nullable
    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityBucket();
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return func_176223_P();
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState above = worldIn.func_180495_p(pos.func_177984_a());
        if (above.func_177230_c() instanceof BlockRope || worldIn.func_175625_s(pos.func_177984_a()) instanceof TileEntityPulley) {
            return func_176223_P().func_177226_a(CONNECTED, true);
        }
        return super.func_176221_a(state, worldIn, pos).func_177226_a(CONNECTED, false);
    }

    @Override
    public boolean canMovePlatforms(World world, BlockPos pos) {
        return false;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}
