package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import betterwithmods.util.StackIngredient;
import betterwithmods.util.player.PlayerHelper;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import javax.annotation.Nullable;

/**
 * Created by primetoxinz on 7/21/17.
 */
public class BlockBrokenGearbox extends BWMBlock {
    public static final PropertyInteger REPAIR = PropertyInteger.func_177719_a("repair", 0, 1);

    public EnumTier type;
    public Ingredient repairIngredient;

    public BlockBrokenGearbox(EnumTier type) {
        super(Material.field_151575_d);
        this.type = type;
        if (type == EnumTier.WOOD) {
            repairIngredient = StackIngredient.fromStacks(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GEAR, 2));
        } else {
            repairIngredient = StackIngredient.fromStacks(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.STEEL_GEAR, 2));
        }
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (PlayerHelper.isHolding(playerIn, repairIngredient)) {
            if (InvUtils.usePlayerItemStrict(playerIn, EnumFacing.UP, repairIngredient, type == EnumTier.WOOD ? 2 : 4)) {
                Block block = type == EnumTier.WOOD ? BWMBlocks.WOODEN_GEARBOX : BWMBlocks.STEEL_GEARBOX;
                worldIn.func_175656_a(pos, block.func_176223_P().func_177226_a(DirUtils.FACING, state.func_177229_b(DirUtils.FACING)));
                worldIn.func_184133_a(null, pos, SoundEvents.field_187873_gM, SoundCategory.BLOCKS, 1, 1);
            }
            return true;
        }
        return false;
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(DirUtils.FACING, facing);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, DirUtils.FACING, REPAIR);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return func_176223_P().func_177226_a(DirUtils.FACING, EnumFacing.field_82609_l[meta & 3]).func_177226_a(REPAIR, (meta >> 3));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int facing = state.func_177229_b(DirUtils.FACING).func_176745_a();
        int type = state.func_177229_b(REPAIR);
        return facing | type << 3;
    }

    @Override
    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (type == EnumTier.STEEL)
            return 4000f;
        return 0;
    }

    @Override
    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        if (type == EnumTier.STEEL)
            return 100f;
        return 3.5f;
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (type == EnumTier.STEEL)
            return SoundType.field_185852_e;
        return SoundType.field_185848_a;
    }

    @Override
    public Material func_149688_o(IBlockState state) {
        if (type == EnumTier.STEEL)
            return Material.field_151573_f;
        return Material.field_151575_d;
    }

    @Override
    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return type != EnumTier.STEEL || entity instanceof EntityPlayer;
    }

    @Override
    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (type != EnumTier.STEEL) {
            super.onBlockExploded(world, pos, explosion);
        }
    }
}
