package betterwithmods.common.blocks;

import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.world.gen.feature.WorldGenBloodTree;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.event.terraingen.TerrainGen;

import java.util.Random;

public class BlockBloodSapling extends BlockBush {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a("stage", 0, 1);
    private static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552D, 0.0D, 0.09999999403953552D, 0.8999999761581421D, 0.800000011920929D, 0.8999999761581421D);

    public BlockBloodSapling() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(STAGE, 0));
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_149672_a(SoundType.field_185850_c);
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return false;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return soil.func_177230_c().canSustainPlant(soil, worldIn, pos.func_177977_b(), EnumFacing.UP, this);
    }

    @Override
    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this) {
            IBlockState soil = world.func_180495_p(pos.func_177977_b());
            return soil.func_177230_c().canSustainPlant(soil, world, pos.func_177977_b(), EnumFacing.UP, this);
        }
        return func_185514_i(world.func_180495_p(pos.func_177977_b()));
    }

    @Override
    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150425_aM || (state.func_177230_c() == BWMBlocks.PLANTER && state.func_177229_b(BlockPlanter.TYPE) == BlockPlanter.EnumType.SOULSAND);
    }

    public void grow(World world, BlockPos pos, IBlockState state, Random rand) {
        if (state.func_177229_b(STAGE) == 0) {
            world.func_180501_a(pos, state.func_177231_a(STAGE), 4);
        } else {
            this.generateTree(world, pos, state, rand);
        }
    }

    public boolean generateTree(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree(world, rand, pos)) return false;
        WorldGenerator gen = new WorldGenBloodTree();

        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());

        if (!gen.func_180709_b(world, rand, pos)) {
            world.func_175656_a(pos, state);
            return false;
        }
        return true;
    }

    @Override
    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Nether;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(STAGE) == 1 ? 8 : 0;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(STAGE, meta == 8 ? 1 : 0);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, STAGE);
    }
}
