package betterwithmods.common.blocks;

import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWSounds;
import betterwithmods.common.world.gen.feature.WorldGenBloodTree;
import betterwithmods.util.DirUtils;
import com.google.common.collect.Lists;
import net.minecraft.block.BlockLog;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

import net.minecraft.block.BlockLog.EnumAxis;

public class BlockBloodLog extends BlockLog {
    public static final PropertyBool EXPANDABLE = PropertyBool.func_177716_a("expandable");

    public static final SoundType BLOODWOOD = new SoundType(1.0F, 1.0F, BWSounds.BLOODWOOD_BREAK, SoundEvents.field_187897_gY, SoundEvents.field_187891_gV, SoundEvents.field_187889_gU, SoundEvents.field_187887_gT);

    public BlockBloodLog() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(field_176299_a, EnumAxis.Y).func_177226_a(EXPANDABLE, false));
        this.func_149675_a(true);
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_149672_a(SoundType.field_185859_l);
    }

    @Override
    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        world.func_184133_a(null, pos, SoundEvents.field_187555_bJ, SoundCategory.BLOCKS, 1f,0.2f);
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return false;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && world.field_73011_w.func_177495_o() && state.func_177229_b(EXPANDABLE)) {
            for (EnumFacing face : DirUtils.NOT_DOWN) {
                if (rand.nextInt(20) == 0)
                    expandTree(world, pos, face);
            }
        }
    }

    private void expandTree(World world, BlockPos pos, EnumFacing facing) {
        WorldGenBloodTree tree = new WorldGenBloodTree();
        tree.generateBranch(world, pos, facing);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P().func_177226_a(EXPANDABLE, (meta & 3) % 4 == 1);
        switch (meta & 12)
        {
            case 0:
                state = state.func_177226_a(field_176299_a, BlockLog.EnumAxis.Y);
                break;
            case 4:
                state = state.func_177226_a(field_176299_a, BlockLog.EnumAxis.X);
                break;
            case 8:
                state = state.func_177226_a(field_176299_a, BlockLog.EnumAxis.Z);
                break;
            default:
                state = state.func_177226_a(field_176299_a, BlockLog.EnumAxis.NONE);
        }
        return state;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = state.func_177229_b(EXPANDABLE) ? 1 : 0;

        switch (state.func_177229_b(field_176299_a))
        {
            case X:
                meta |= 4;
                break;
            case Z:
                meta |= 8;
                break;
            case NONE:
                meta |= 12;
        }
        return meta;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, EXPANDABLE, field_176299_a);
    }
}
