package betterwithmods.common.blocks;

import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class BlockBloodLeaves extends BlockLeaves {
    public BlockBloodLeaves() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(field_176236_b, false).func_177226_a(field_176237_a, false));
        this.func_149647_a(BWCreativeTabs.BWTAB);
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P();
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return false;
    }

    @Override
    public BlockPlanks.EnumType func_176233_b(int meta)
    {
        return BlockPlanks.EnumType.JUNGLE;
    }

    @Override
    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return Arrays.asList(new ItemStack(this, 1, 0));
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a(BWMBlocks.BLOOD_SAPLING);
    }

    @Override
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(BWMBlocks.BLOOD_SAPLING);
    }

    @Override
    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(BWMBlocks.BLOOD_LEAVES);
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @Override
    @SideOnly(Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    @Override
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        this.field_185686_c = !Blocks.field_150362_t.func_149662_c(state);
        return super.func_176225_a(state, world, pos, side);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(field_176237_a, (meta & 4) == 0).func_177226_a(field_176236_b, (meta & 8) > 0);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = state.func_177229_b(field_176237_a) ? 4 : 0;
        if (state.func_177229_b(field_176236_b)) meta += 8;
        return meta;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, field_176237_a, field_176236_b);
    }
}
