package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.util.DirUtils;
import com.google.common.collect.Sets;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import java.util.Random;
import java.util.Set;

import static net.minecraft.util.EnumFacing.UP;

/**
 * Created by primetoxinz on 9/4/16.
 */
public class BlockBUD extends BWMBlock {
    private static final PropertyBool REDSTONE = PropertyBool.func_177716_a("redstone");
    private static Set<Block> BLACKLIST = Sets.newHashSet(BWMBlocks.BUDDY_BLOCK, Blocks.field_150488_af, Blocks.field_150416_aS, Blocks.field_150413_aR, Blocks.field_150429_aA, Blocks.field_150437_az, BWMBlocks.LIGHT);

    public BlockBUD() {
        super(Material.field_151576_e);
        func_149711_c(3.5F);
        func_149672_a(SoundType.field_185851_d);
        func_180632_j(func_176223_P().func_177226_a(DirUtils.FACING, UP));
        this.setHarvestLevel("pickaxe", 0);
    }

    public static void addBlacklistBlock(Block block) {
        BLACKLIST.add(block);
    }

    @Override
    public int func_149738_a(World var1) {
        return 5;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, DirUtils.FACING, REDSTONE);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        int facing = (meta >> 1);
        boolean redstone = (meta & 1) == 1;
        return func_176223_P().func_177226_a(REDSTONE, redstone).func_177226_a(DirUtils.FACING, EnumFacing.func_82600_a(facing));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int facing = state.func_177229_b(DirUtils.FACING).func_176745_a();
        int redstone = state.func_177229_b(REDSTONE) ? 1 : 0;
        return redstone | facing << 1;
    }

    @Override
    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a(DirUtils.FACING, DirUtils.convertEntityOrientationToFacing(placer, UP));
    }

    @Override
    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        worldIn.func_175684_a(pos, state.func_177230_c(), 1);
    }

    @Override
    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos other) {
        if (!isRedstoneOn(world, pos) && !BLACKLIST.contains(blockIn)) {
            world.func_175684_a(pos, state.func_177230_c(), func_149738_a(world));
        }
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (isRedstoneOn(worldIn, pos)) {
            setRedstone(worldIn, pos, false);
        } else {
            setRedstone(worldIn, pos, true);
            worldIn.func_175684_a(pos, state.func_177230_c(), func_149738_a(worldIn));
        }
    }

    public void setRedstone(World world, BlockPos pos, boolean newState) {
        if (newState != isRedstoneOn(world, pos)) {
            if (newState) {
                world.func_184133_a(null, pos, SoundEvents.field_187576_at, SoundCategory.BLOCKS, 1, .5f);
            }

            BlockPos facing = pos.func_177972_a(getFacing(world.func_180495_p(pos)));
            if (!world.func_175623_d(facing)) {
                world.func_180495_p(facing).func_177230_c().onNeighborChange(world, facing, pos);
            }
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a(REDSTONE, newState));
        }
    }

    public boolean isRedstoneOn(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177229_b(REDSTONE);
    }

    @Override
    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return getPower(blockAccess, pos, side);
    }

    @Override
    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return getPower(blockAccess, pos, side);
    }

    public int getPower(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side.func_176734_d() == getFacing(world.func_180495_p(pos)) && isRedstoneOn(world, pos) ? 15 : 0;
    }

    public EnumFacing getFacing(IBlockState state) {
        return state.func_177229_b(DirUtils.FACING);
    }

    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.func_177226_a(DirUtils.FACING, facing);
    }
}
